"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, ConfigDict

from snowflake.core.cortex.analyst_service._generated.models.staging_data import StagingData, StagingDataModel
from snowflake.core.cortex.analyst_service._generated.models.tableau_auth import TableauAuth, TableauAuthModel


class TableauIntegration(BaseModel):
    """A model object representing the TableauIntegration resource.

    Constructs an object of type TableauIntegration with the provided properties.

    Parameters
    __________
    auth : TableauAuth

    staging_data : StagingData
    """

    auth: TableauAuth

    staging_data: StagingData

    __properties = ["auth", "staging_data"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableauIntegration:
        """Create an instance of TableauIntegration from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of auth
        if self.auth:
            _dict["auth"] = self.auth.to_dict()

        # override the default output from pydantic by calling `to_dict()` of staging_data
        if self.staging_data:
            _dict["staging_data"] = self.staging_data.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableauIntegration:
        """Create an instance of TableauIntegration from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableauIntegration.model_validate(obj)

        _obj = TableauIntegration.model_validate(
            {
                "auth": TableauAuth.from_dict(obj.get("auth")) if obj.get("auth") is not None else None,
                "staging_data": StagingData.from_dict(obj.get("staging_data"))
                if obj.get("staging_data") is not None
                else None,
            }
        )

        return _obj


class TableauIntegrationModel:
    def __init__(
        self,
        auth: TableauAuth,
        staging_data: StagingData,
        # optional properties
    ):
        """A model object representing the TableauIntegration resource.

        Constructs an object of type TableauIntegration with the provided properties.

        Parameters
        __________
        auth : TableauAuth

        staging_data : StagingData
        """
        self.auth = auth
        self.staging_data = staging_data

    __properties = ["auth", "staging_data"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableauIntegration(
            auth=self.auth._to_model() if self.auth is not None else None,
            staging_data=self.staging_data._to_model() if self.staging_data is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> TableauIntegrationModel:
        return TableauIntegrationModel(
            auth=TableauAuthModel._from_model(model.auth) if model.auth else None,
            staging_data=StagingDataModel._from_model(model.staging_data) if model.staging_data else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TableauIntegration.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableauIntegration object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableauIntegrationModel:
        """Create an instance of TableauIntegration from a dict.

        This method constructs a TableauIntegration object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableauIntegration
            A TableauIntegration object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableauIntegration.from_dict(obj))


TableauIntegration._model_class = TableauIntegrationModel
