"""
Cortex Embed API.

OpenAPI 3.0 specification for the Cortex Embed REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Annotated


class EmbedRequest(BaseModel):
    """A model object representing the EmbedRequest resource.

    Constructs an object of type EmbedRequest with the provided properties.

    Parameters
    __________
    model : str
        Identifier of the model to use for generating embeddings.
        Refer to Snowflake documentation for the list of supported models.

        Examples:
          - `snowflake-arctic-embed-m`
          - `snowflake-arctic-embed-m-v1.5`
    text : list[str]
        An array of input texts for which vector embeddings will be calculated.
        Example: ["Hello world", "Machine learning is fascinating"]
    provisioned_throughput_id : str, optional
        The provisioned throughput ID to be used with the request.
    """

    model: StrictStr

    text: Annotated[List[StrictStr], Field(min_length=1)]

    provisioned_throughput_id: Optional[StrictStr] = None

    __properties = ["model", "text", "provisioned_throughput_id"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EmbedRequest:
        """Create an instance of EmbedRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # set to None if provisioned_throughput_id (nullable) is None
        if self.provisioned_throughput_id is None:
            _dict["provisioned_throughput_id"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedRequest:
        """Create an instance of EmbedRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EmbedRequest.model_validate(obj)

        _obj = EmbedRequest.model_validate(
            {
                "model": obj.get("model"),
                "text": obj.get("text"),
                "provisioned_throughput_id": obj.get("provisioned_throughput_id"),
            }
        )

        return _obj


class EmbedRequestModel:
    def __init__(
        self,
        model: str,
        text: list[str],
        # optional properties
        provisioned_throughput_id: Optional[str] = None,
    ):
        """A model object representing the EmbedRequest resource.

                Constructs an object of type EmbedRequest with the provided properties.

                Parameters
                __________
                model : str
                    Identifier of the model to use for generating embeddings.
        Refer to Snowflake documentation for the list of supported models.

        Examples:
          - `snowflake-arctic-embed-m`
          - `snowflake-arctic-embed-m-v1.5`

                text : list[str]
                    An array of input texts for which vector embeddings will be calculated.
        Example: ["Hello world", "Machine learning is fascinating"]

                provisioned_throughput_id : str, optional
                    The provisioned throughput ID to be used with the request.
        """
        self.model = model
        self.text = text
        self.provisioned_throughput_id = provisioned_throughput_id

    __properties = ["model", "text", "provisioned_throughput_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return EmbedRequest(
            model=self.model,
            text=self.text,
            provisioned_throughput_id=self.provisioned_throughput_id,
        )

    @classmethod
    def _from_model(cls, model) -> EmbedRequestModel:
        return EmbedRequestModel(
            model=model.model,
            text=model.text,
            provisioned_throughput_id=model.provisioned_throughput_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a EmbedRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the EmbedRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EmbedRequestModel:
        """Create an instance of EmbedRequest from a dict.

        This method constructs a EmbedRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        EmbedRequest
            A EmbedRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(EmbedRequest.from_dict(obj))


EmbedRequest._model_class = EmbedRequestModel
