"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.search_service._generated.models.functions import Functions, FunctionsModel
from snowflake.core.cortex.search_service._generated.models.ranking_weights import RankingWeights, RankingWeightsModel
from snowflake.core.cortex.search_service._generated.models.retrieval_weights import (
    RetrievalWeights,
    RetrievalWeightsModel,
)
from snowflake.core.cortex.search_service._generated.models.weights import Weights, WeightsModel


class ScoringConfig(BaseModel):
    """A model object representing the ScoringConfig resource.

    Constructs an object of type ScoringConfig with the provided properties.

    Parameters
    __________
    functions : Functions, optional

    reranker : str, optional
        Model to use for the reranker, or "none" if the reranker should be turned off. If excluded or null, the default reranker is used.
    weights : Weights, optional

    retrieval_weights : RetrievalWeights, optional

    ranking_weights : RankingWeights, optional
    """

    functions: Optional[Functions] = None

    reranker: Optional[StrictStr] = None

    weights: Optional[Weights] = None

    retrieval_weights: Optional[RetrievalWeights] = None

    ranking_weights: Optional[RankingWeights] = None

    __properties = ["functions", "reranker", "weights", "retrieval_weights", "ranking_weights"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScoringConfig:
        """Create an instance of ScoringConfig from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of functions
        if self.functions:
            _dict["functions"] = self.functions.to_dict()

        # override the default output from pydantic by calling `to_dict()` of weights
        if self.weights:
            _dict["weights"] = self.weights.to_dict()

        # override the default output from pydantic by calling `to_dict()` of retrieval_weights
        if self.retrieval_weights:
            _dict["retrieval_weights"] = self.retrieval_weights.to_dict()

        # override the default output from pydantic by calling `to_dict()` of ranking_weights
        if self.ranking_weights:
            _dict["ranking_weights"] = self.ranking_weights.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ScoringConfig:
        """Create an instance of ScoringConfig from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ScoringConfig.model_validate(obj)

        _obj = ScoringConfig.model_validate(
            {
                "functions": Functions.from_dict(obj.get("functions")) if obj.get("functions") is not None else None,
                "reranker": obj.get("reranker"),
                "weights": Weights.from_dict(obj.get("weights")) if obj.get("weights") is not None else None,
                "retrieval_weights": RetrievalWeights.from_dict(obj.get("retrieval_weights"))
                if obj.get("retrieval_weights") is not None
                else None,
                "ranking_weights": RankingWeights.from_dict(obj.get("ranking_weights"))
                if obj.get("ranking_weights") is not None
                else None,
            }
        )

        return _obj


class ScoringConfigModel:
    def __init__(
        self,  # optional properties
        functions: Optional[Functions] = None,
        reranker: Optional[str] = None,
        weights: Optional[Weights] = None,
        retrieval_weights: Optional[RetrievalWeights] = None,
        ranking_weights: Optional[RankingWeights] = None,
    ):
        """A model object representing the ScoringConfig resource.

        Constructs an object of type ScoringConfig with the provided properties.

        Parameters
        __________
        functions : Functions, optional

        reranker : str, optional
            Model to use for the reranker, or "none" if the reranker should be turned off. If excluded or null, the default reranker is used.
        weights : Weights, optional

        retrieval_weights : RetrievalWeights, optional

        ranking_weights : RankingWeights, optional
        """
        self.functions = functions
        self.reranker = reranker
        self.weights = weights
        self.retrieval_weights = retrieval_weights
        self.ranking_weights = ranking_weights

    __properties = ["functions", "reranker", "weights", "retrieval_weights", "ranking_weights"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ScoringConfig(
            functions=self.functions._to_model() if self.functions is not None else None,
            reranker=self.reranker,
            weights=self.weights._to_model() if self.weights is not None else None,
            retrieval_weights=self.retrieval_weights._to_model() if self.retrieval_weights is not None else None,
            ranking_weights=self.ranking_weights._to_model() if self.ranking_weights is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> ScoringConfigModel:
        return ScoringConfigModel(
            functions=FunctionsModel._from_model(model.functions) if model.functions else None,
            reranker=model.reranker,
            weights=WeightsModel._from_model(model.weights) if model.weights else None,
            retrieval_weights=RetrievalWeightsModel._from_model(model.retrieval_weights)
            if model.retrieval_weights
            else None,
            ranking_weights=RankingWeightsModel._from_model(model.ranking_weights) if model.ranking_weights else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ScoringConfig.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ScoringConfig object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ScoringConfigModel:
        """Create an instance of ScoringConfig from a dict.

        This method constructs a ScoringConfig object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ScoringConfig
            A ScoringConfig object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ScoringConfig.from_dict(obj))


ScoringConfig._model_class = ScoringConfigModel
