from enum import Enum


class Privileges(Enum):
    """Enum for Snowflake privileges that can be granted to a role or user."""

    add_search_optimization = "ADD SEARCH OPTIMIZATION"
    all_privileges = "ALL PRIVILEGES"
    apply = "APPLY"
    applybudget = "APPLYBUDGET"
    apply_aggregation_policy = "APPLY AGGREGATION POLICY"
    apply_authentication_policy = "APPLY AUTHENTICATION POLICY"
    apply_masking_policy = "APPLY MASKING POLICY"
    apply_packages_policy = "APPLY PACKAGES POLICY"
    apply_password_policy = "APPLY PASSWORD POLICY"
    apply_projection_policy = "APPLY PROJECTION POLICY"
    apply_row_access_policy = "APPLY ROW ACCESS POLICY"
    apply_session_policy = "APPLY SESSION POLICY"
    apply_tag = "APPLY TAG"
    attach_listing = "ATTACH LISTING"
    attach_policy = "ATTACH POLICY"
    audit = "AUDIT"
    bind_service_endpoint = "BIND SERVICE ENDPOINT"
    create_account = "CREATE ACCOUNT"
    create_aggregation_policy = "CREATE AGGREGATION POLICY"
    create_alert = "CREATE ALERT"
    create_application = "CREATE APPLICATION"
    create_projection_policy = "CREATE PROJECTION POLICY"
    create_application_package = "CREATE APPLICATION PACKAGE"
    create_authentication_policy = "CREATE AUTHENTICATION POLICY"
    create_compute_pool = "CREATE COMPUTE POOL"
    create_database = "CREATE DATABASE"
    create_database_role = "CREATE DATABASE ROLE"
    create_dataset = "CREATE DATASET"
    create_data_exchange_listing = "CREATE DATA EXCHANGE LISTING"
    create_dynamic_table = "CREATE DYNAMIC TABLE"
    create_event_table = "CREATE EVENT TABLE"
    create_external_table = "CREATE EXTERNAL TABLE"
    create_external_volume = "CREATE EXTERNAL VOLUME"
    create_failover_group = "CREATE FAILOVER GROUP"
    create_file_format = "CREATE FILE FORMAT"
    create_function = "CREATE FUNCTION"
    create_git_repository = "CREATE GIT REPOSITORY"
    create_hybrid_table = "CREATE HYBRID TABLE"
    create_iceberg_table = "CREATE ICEBERG TABLE"
    create_image_repository = "CREATE IMAGE REPOSITORY"
    create_integration = "CREATE INTEGRATION"
    create_masking_policy = "CREATE MASKING POLICY"
    create_materialized_view = "CREATE MATERIALIZED VIEW"
    create_model = "CREATE MODEL"
    create_network_policy = "CREATE NETWORK POLICY"
    create_network_rule = "CREATE NETWORK RULE"
    create_notebook = "CREATE NOTEBOOK"
    create_packages_policy = "CREATE PACKAGES POLICY"
    create_password_policy = "CREATE PASSWORD POLICY"
    create_pipe = "CREATE PIPE"
    create_procedure = "CREATE PROCEDURE"
    create_replication_group = "CREATE REPLICATION GROUP"
    create_role = "CREATE ROLE"
    create_row_access_policy = "CREATE ROW ACCESS POLICY"
    create_schema = "CREATE SCHEMA"
    create_sequence = "CREATE SEQUENCE"
    create_secret = "CREATE SECRET"
    create_service = "CREATE SERVICE"
    create_session_policy = "CREATE SESSION POLICY"
    create_share = "CREATE SHARE"
    create_snapshot = "CREATE SNAPSHOT"
    create_snowflake_core_budget = "CREATE SNOWFLAKE.CORE.BUDGET"
    create_snowflake_ml_anomaly_detection = "CREATE SNOWFLAKE.ML.ANOMALY_DETECTION"
    create_snowflake_ml_forecast = "CREATE SNOWFLAKE.ML.FORECAST"
    create_stage = "CREATE STAGE"
    create_stream = "CREATE STREAM"
    create_streamlit = "CREATE STREAMLIT"
    create_table = "CREATE TABLE"
    create_tag = "CREATE TAG"
    create_task = "CREATE TASK"
    create_user = "CREATE USER"
    create_view = "CREATE VIEW"
    create_warehouse = "CREATE WAREHOUSE"
    delete = "DELETE"
    develop = "DEVELOP"
    evolve_schema = "EVOLVE SCHEMA"
    execute_alert = "EXECUTE ALERT"
    execute_data_metric_function = "EXECUTE DATA METRIC FUNCTION"
    execute_managed_alert = "EXECUTE MANAGED ALERT"
    execute_managed_task = "EXECUTE MANAGED TASK"
    execute_task = "EXECUTE TASK"
    failover = "FAILOVER"
    import_share = "IMPORT SHARE"
    imported_privileges = "IMPORTED PRIVILEGES"
    insert = "INSERT"
    install = "INSTALL"
    manage_account_support_cases = "MANAGE ACCOUNT SUPPORT CASES"
    manage_event_sharing = "MANAGE EVENT SHARING"
    manage_grants = "MANAGE GRANTS"
    manage_listing_autofulfillment = "MANAGE LISTING AUTO FULFILLMENT"
    manage_organization_support_cases = "MANAGE ORGANIZATION SUPPORT CASES"
    manage_releases = "MANAGE RELEASES"
    manage_user_support_cases = "MANAGE USER SUPPORT CASES"
    manage_version = "MANAGE VERSION"
    manage_warehouses = "MANAGE WAREHOUSES"
    modify = "MODIFY"
    modify_log_level = "MODIFY LOG LEVEL"
    modify_session_log_level = "MODIFY SESSION LOG LEVEL"
    modify_trace_level = "MODIFY TRACE LEVEL"
    modify_session_trace_level = "MODIFY SESSION TRACE LEVEL"
    monitor = "MONITOR"
    monitor_execution = "MONITOR EXECUTION"
    monitor_security = "MONITOR SECURITY"
    monitor_usage = "MONITOR USAGE"
    operate = "OPERATE"
    override_share_restrictions = "OVERRIDE SHARE RESTRICTIONS"
    purchase_data_exchange_listing = "PURCHASE DATA EXCHANGE LISTING"
    read = "READ"
    references = "REFERENCES"
    reference_usage = "REFERENCE_USAGE"
    replicate = "REPLICATE"
    resolve_all = "RESOLVE ALL"
    select = "SELECT"
    truncate = "TRUNCATE"
    update = "UPDATE"
    use_any_role = "USE ANY ROLE"
    usage = "USAGE"
    write = "WRITE"
