"""
Snowflake Iceberg Table API.

The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr


class IcebergTableFromAWSGlueCatalog(BaseModel):
    """A model object representing the IcebergTableFromAWSGlueCatalog resource.

    Constructs an object of type IcebergTableFromAWSGlueCatalog with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the table, must be unique for the schema in which the table is created
    catalog_table_name : str
        Specifies the table name as recognized by the AWS Glue Data Catalog.
    external_volume : str, optional
        Specifies the name of the external volume to use for the table
    catalog_namespace : str, optional
        Specifies the catalog namespace for the table.
    replace_invalid_characters : bool, optional
        Specifies whether to replace invalid characters in the column names
    auto_refresh : bool, optional
        Specifies whether to automatically refresh the table metadata
    catalog : str, optional
        Specifies the name of the catalog integration to use for the table
    comment : str, optional
        Specifies a comment for the table
    """

    name: StrictStr

    external_volume: Optional[StrictStr] = None

    catalog_table_name: StrictStr

    catalog_namespace: Optional[StrictStr] = None

    replace_invalid_characters: Optional[StrictBool] = None

    auto_refresh: Optional[StrictBool] = None

    catalog: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    __properties = [
        "name",
        "external_volume",
        "catalog_table_name",
        "catalog_namespace",
        "replace_invalid_characters",
        "auto_refresh",
        "catalog",
        "comment",
    ]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergTableFromAWSGlueCatalog:
        """Create an instance of IcebergTableFromAWSGlueCatalog from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableFromAWSGlueCatalog:
        """Create an instance of IcebergTableFromAWSGlueCatalog from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IcebergTableFromAWSGlueCatalog.model_validate(obj)

        _obj = IcebergTableFromAWSGlueCatalog.model_validate(
            {
                "name": obj.get("name"),
                "external_volume": obj.get("external_volume"),
                "catalog_table_name": obj.get("catalog_table_name"),
                "catalog_namespace": obj.get("catalog_namespace"),
                "replace_invalid_characters": obj.get("replace_invalid_characters"),
                "auto_refresh": obj.get("auto_refresh"),
                "catalog": obj.get("catalog"),
                "comment": obj.get("comment"),
            }
        )

        return _obj


class IcebergTableFromAWSGlueCatalogModel:
    def __init__(
        self,
        name: str,
        catalog_table_name: str,
        # optional properties
        external_volume: Optional[str] = None,
        catalog_namespace: Optional[str] = None,
        replace_invalid_characters: Optional[bool] = None,
        auto_refresh: Optional[bool] = None,
        catalog: Optional[str] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the IcebergTableFromAWSGlueCatalog resource.

        Constructs an object of type IcebergTableFromAWSGlueCatalog with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the table, must be unique for the schema in which the table is created
        catalog_table_name : str
            Specifies the table name as recognized by the AWS Glue Data Catalog.
        external_volume : str, optional
            Specifies the name of the external volume to use for the table
        catalog_namespace : str, optional
            Specifies the catalog namespace for the table.
        replace_invalid_characters : bool, optional
            Specifies whether to replace invalid characters in the column names
        auto_refresh : bool, optional
            Specifies whether to automatically refresh the table metadata
        catalog : str, optional
            Specifies the name of the catalog integration to use for the table
        comment : str, optional
            Specifies a comment for the table
        """
        self.name = name
        self.external_volume = external_volume
        self.catalog_table_name = catalog_table_name
        self.catalog_namespace = catalog_namespace
        self.replace_invalid_characters = replace_invalid_characters
        self.auto_refresh = auto_refresh
        self.catalog = catalog
        self.comment = comment

    __properties = [
        "name",
        "external_volume",
        "catalog_table_name",
        "catalog_namespace",
        "replace_invalid_characters",
        "auto_refresh",
        "catalog",
        "comment",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return IcebergTableFromAWSGlueCatalog(
            name=self.name,
            external_volume=self.external_volume,
            catalog_table_name=self.catalog_table_name,
            catalog_namespace=self.catalog_namespace,
            replace_invalid_characters=self.replace_invalid_characters,
            auto_refresh=self.auto_refresh,
            catalog=self.catalog,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> IcebergTableFromAWSGlueCatalogModel:
        return IcebergTableFromAWSGlueCatalogModel(
            name=model.name,
            external_volume=model.external_volume,
            catalog_table_name=model.catalog_table_name,
            catalog_namespace=model.catalog_namespace,
            replace_invalid_characters=model.replace_invalid_characters,
            auto_refresh=model.auto_refresh,
            catalog=model.catalog,
            comment=model.comment,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a IcebergTableFromAWSGlueCatalog.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the IcebergTableFromAWSGlueCatalog object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableFromAWSGlueCatalogModel:
        """Create an instance of IcebergTableFromAWSGlueCatalog from a dict.

        This method constructs a IcebergTableFromAWSGlueCatalog object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        IcebergTableFromAWSGlueCatalog
            A IcebergTableFromAWSGlueCatalog object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(IcebergTableFromAWSGlueCatalog.from_dict(obj))


IcebergTableFromAWSGlueCatalog._model_class = IcebergTableFromAWSGlueCatalogModel
