"""
Snowflake Notebook API.

The Snowflake Notebook API is a REST API that you can use to access, update, and perform certain actions on Notebook resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import warnings

from typing import TYPE_CHECKING, Any, Iterator, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.notebook._generated.models.notebook import Notebook

from .notebook_api import NotebookApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class NotebookCollectionBase(SchemaObjectCollectionParent["NotebookResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = NotebookApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(self, notebook: Notebook, mode: Optional[Union[CreateMode, str]] = None) -> "NotebookResource":  # noqa: F821
        """Create a notebook.

        Parameters
        __________
        notebook: Notebook
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_notebook(
            self.database.name,
            self.schema.name,
            notebook=notebook,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(notebook), self)
        return self._ref_class(notebook.name, self)

    @api_telemetry
    def create_async(
        self, notebook: Notebook, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["NotebookResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_notebook(
            self.database.name,
            self.schema.name,
            notebook=notebook,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(future, lambda _: self._ref_class(get_function_name_with_args(notebook), self))
        return PollingOperation(
            future, lambda _: self._ref_class(notebook if isinstance(notebook, str) else notebook.name, self)
        )

    @api_telemetry
    def iter(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        from_name: Optional[str] = None,
        show_limit: Optional[int] = None,
    ) -> Iterator[Notebook]:
        """List notebooks.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        starts_with: str
             Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        limit: int
             Parameter to limit the maximum number of rows returned by a command.
        from_name: str
             Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        resources = self._api.list_notebooks(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            from_name=from_name,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        from_name: Optional[str] = None,
        show_limit: Optional[int] = None,
    ) -> PollingOperation[Iterator[Notebook]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        future = self._api.list_notebooks(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            from_name=from_name,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class NotebookResourceBase(SchemaObjectReferenceMixin["NotebookCollection"]):
    _collection_class: NotebookCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: NotebookCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def add_live_version(
        self,
        from_last: Optional[bool] = None,
        comment: Optional[str] = None,
    ) -> None:
        """Adds a LIVE version to the notebook.

        Parameters
        __________
        from_last: bool
             Sets the LIVE version to the LAST version of the notebook
        comment: str
             Sets a comment for the notebook or version of the notebook
        """
        self.collection._api.add_live_version_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            from_last=from_last,
            comment=comment,
            async_req=False,
        )

    @api_telemetry
    def add_live_version_async(
        self,
        from_last: Optional[bool] = None,
        comment: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`add_live_version`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.add_live_version_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            from_last=from_last,
            comment=comment,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def commit(
        self,
        version: Optional[str] = None,
        comment: Optional[str] = None,
    ) -> None:
        """Commits the LIVE version of the notebook.

        Parameters
        __________
        version: str
             live version of the alias
        comment: str
             Sets a comment for the notebook or version of the notebook
        """
        self.collection._api.commit_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            version=version,
            comment=comment,
            async_req=False,
        )

    @api_telemetry
    def commit_async(
        self,
        version: Optional[str] = None,
        comment: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`commit`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.commit_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            version=version,
            comment=comment,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def execute(
        self,
        async_exec: Optional[bool] = None,
    ) -> None:
        """Execute a Notebook.

        Parameters
        __________
        async_exec: bool
             Asynchronous execution enable/disable. Default is disable.
        """
        self.collection._api.execute_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_exec=async_exec,
            async_req=False,
        )

    @api_telemetry
    def execute_async(
        self,
        async_exec: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`execute`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.execute_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_exec=async_exec,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def fetch(
        self,
    ) -> Notebook:
        """Fetch a notebook.

        Parameters
        __________
        """
        return self.collection._api.fetch_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[Notebook]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def rename(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> None:
        """Changes the name of the notebook to new name.

        Parameters
        __________
        target_name: str
             Name of the target resource. (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        target_database: str
             Database of the target resource. Defaults to the source's database
        target_schema: str
             Schema of the target resource. Defaults to the source's schema
        """
        self.collection._api.rename_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=False,
        )

        self._rename_finalizer(target_name, target_schema, target_database)

    @api_telemetry
    def rename_async(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`rename`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.rename_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=True,
        )

        def finalize(_: Any) -> None:
            self._rename_finalizer(
                target_name=target_name, target_schema=target_schema, target_database=target_database
            )

        return PollingOperation(future, finalize)

    def _rename_finalizer(self, target_name: str, target_schema: Optional[str], target_database: Optional[str]) -> None:
        """Finalizer for rename operation."""
        self._set_new_name(target_name)
        if target_database is None:
            target_database = self.database.name
        if target_schema is None:
            target_schema = self.schema.name

        # Schema level resource
        if target_database != self.database.name or target_schema != self.schema.name:
            self.collection = getattr(self.root.databases[target_database].schemas[target_schema], self._plural_name)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a notebook.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_notebook(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
