"""
Snowflake Password Policy API.

The Snowflake Password Policy API is a REST API that you can use to access, update, and perform certain actions on Password Policy resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated


class PasswordPolicy(BaseModel):
    """A model object representing the PasswordPolicy resource.

    Constructs an object of type PasswordPolicy with the provided properties.

    Parameters
    __________
    name : str
        Name of the password policy
    comment : str, optional
        Comment for the password policy
    password_min_length : int, optional
        Minimum length of new password.
    password_max_length : int, optional
        Maximum length of new password.
    password_min_upper_case_chars : int, optional
        Minimum number of uppercase characters in new password.
    password_min_lower_case_chars : int, optional
        Minimum number of lowercase characters in new password.
    password_min_numeric_chars : int, optional
        Minimum number of numeric characters in new password.
    password_min_special_chars : int, optional
        Minimum number of special characters in new password.
    password_min_age_days : int, optional
        Period after a password is changed during which a password cannot be changed again, in days.
    password_max_age_days : int, optional
        Period after which password must be changed, in days.
    password_max_retries : int, optional
        Number of attempts users have to enter the correct password before their account is locked.
    password_lockout_time_mins : int, optional
        Period of time for which users will be locked after entering their password incorrectly many times (specified by MAX_RETRIES), in minutes
    password_history : int, optional
        Number of distinct passwords that a user must create before re-using a previous password
    created_on : datetime, optional
        Date and time when the password policy was created — **Read-only:** *any user-provided value will be ignored.*
    database_name : str, optional
        Database in which the password policy is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the password policy is stored — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the password policy — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the password policy — **Read-only:** *any user-provided value will be ignored.*
    """

    comment: Optional[StrictStr] = None

    password_min_length: Optional[StrictInt] = None

    password_max_length: Optional[StrictInt] = None

    password_min_upper_case_chars: Optional[StrictInt] = None

    password_min_lower_case_chars: Optional[StrictInt] = None

    password_min_numeric_chars: Optional[StrictInt] = None

    password_min_special_chars: Optional[StrictInt] = None

    password_min_age_days: Optional[StrictInt] = None

    password_max_age_days: Optional[StrictInt] = None

    password_max_retries: Optional[StrictInt] = None

    password_lockout_time_mins: Optional[StrictInt] = None

    password_history: Optional[StrictInt] = None

    name: Annotated[str, Field(strict=True)]

    created_on: Optional[datetime] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[StrictStr] = None

    __properties = [
        "comment",
        "password_min_length",
        "password_max_length",
        "password_min_upper_case_chars",
        "password_min_lower_case_chars",
        "password_min_numeric_chars",
        "password_min_special_chars",
        "password_min_age_days",
        "password_max_age_days",
        "password_max_retries",
        "password_lockout_time_mins",
        "password_history",
        "name",
        "created_on",
        "database_name",
        "schema_name",
        "owner",
        "owner_role_type",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PasswordPolicy:
        """Create an instance of PasswordPolicy from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "owner",
                    "owner_role_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PasswordPolicy:
        """Create an instance of PasswordPolicy from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PasswordPolicy.model_validate(obj)

        _obj = PasswordPolicy.model_validate(
            {
                "comment": obj.get("comment"),
                "password_min_length": obj.get("password_min_length"),
                "password_max_length": obj.get("password_max_length"),
                "password_min_upper_case_chars": obj.get("password_min_upper_case_chars"),
                "password_min_lower_case_chars": obj.get("password_min_lower_case_chars"),
                "password_min_numeric_chars": obj.get("password_min_numeric_chars"),
                "password_min_special_chars": obj.get("password_min_special_chars"),
                "password_min_age_days": obj.get("password_min_age_days"),
                "password_max_age_days": obj.get("password_max_age_days"),
                "password_max_retries": obj.get("password_max_retries"),
                "password_lockout_time_mins": obj.get("password_lockout_time_mins"),
                "password_history": obj.get("password_history"),
                "name": obj.get("name"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
            }
        )

        return _obj


class PasswordPolicyModel:
    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        password_min_length: Optional[int] = None,
        password_max_length: Optional[int] = None,
        password_min_upper_case_chars: Optional[int] = None,
        password_min_lower_case_chars: Optional[int] = None,
        password_min_numeric_chars: Optional[int] = None,
        password_min_special_chars: Optional[int] = None,
        password_min_age_days: Optional[int] = None,
        password_max_age_days: Optional[int] = None,
        password_max_retries: Optional[int] = None,
        password_lockout_time_mins: Optional[int] = None,
        password_history: Optional[int] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the PasswordPolicy resource.

        Constructs an object of type PasswordPolicy with the provided properties.

        Parameters
        __________
        name : str
            Name of the password policy
        comment : str, optional
            Comment for the password policy
        password_min_length : int, optional
            Minimum length of new password.
        password_max_length : int, optional
            Maximum length of new password.
        password_min_upper_case_chars : int, optional
            Minimum number of uppercase characters in new password.
        password_min_lower_case_chars : int, optional
            Minimum number of lowercase characters in new password.
        password_min_numeric_chars : int, optional
            Minimum number of numeric characters in new password.
        password_min_special_chars : int, optional
            Minimum number of special characters in new password.
        password_min_age_days : int, optional
            Period after a password is changed during which a password cannot be changed again, in days.
        password_max_age_days : int, optional
            Period after which password must be changed, in days.
        password_max_retries : int, optional
            Number of attempts users have to enter the correct password before their account is locked.
        password_lockout_time_mins : int, optional
            Period of time for which users will be locked after entering their password incorrectly many times (specified by MAX_RETRIES), in minutes
        password_history : int, optional
            Number of distinct passwords that a user must create before re-using a previous password
        created_on : datetime, optional
            Date and time when the password policy was created.
        database_name : str, optional
            Database in which the password policy is stored
        schema_name : str, optional
            Schema in which the password policy is stored
        owner : str, optional
            Role that owns the password policy
        owner_role_type : str, optional
            The type of role that owns the password policy
        """
        self.comment = comment
        self.password_min_length = password_min_length
        self.password_max_length = password_max_length
        self.password_min_upper_case_chars = password_min_upper_case_chars
        self.password_min_lower_case_chars = password_min_lower_case_chars
        self.password_min_numeric_chars = password_min_numeric_chars
        self.password_min_special_chars = password_min_special_chars
        self.password_min_age_days = password_min_age_days
        self.password_max_age_days = password_max_age_days
        self.password_max_retries = password_max_retries
        self.password_lockout_time_mins = password_lockout_time_mins
        self.password_history = password_history
        self.name = name
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = [
        "comment",
        "password_min_length",
        "password_max_length",
        "password_min_upper_case_chars",
        "password_min_lower_case_chars",
        "password_min_numeric_chars",
        "password_min_special_chars",
        "password_min_age_days",
        "password_max_age_days",
        "password_max_retries",
        "password_lockout_time_mins",
        "password_history",
        "name",
        "created_on",
        "database_name",
        "schema_name",
        "owner",
        "owner_role_type",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PasswordPolicy(
            comment=self.comment,
            password_min_length=self.password_min_length,
            password_max_length=self.password_max_length,
            password_min_upper_case_chars=self.password_min_upper_case_chars,
            password_min_lower_case_chars=self.password_min_lower_case_chars,
            password_min_numeric_chars=self.password_min_numeric_chars,
            password_min_special_chars=self.password_min_special_chars,
            password_min_age_days=self.password_min_age_days,
            password_max_age_days=self.password_max_age_days,
            password_max_retries=self.password_max_retries,
            password_lockout_time_mins=self.password_lockout_time_mins,
            password_history=self.password_history,
            name=self.name,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> PasswordPolicyModel:
        return PasswordPolicyModel(
            comment=model.comment,
            password_min_length=model.password_min_length,
            password_max_length=model.password_max_length,
            password_min_upper_case_chars=model.password_min_upper_case_chars,
            password_min_lower_case_chars=model.password_min_lower_case_chars,
            password_min_numeric_chars=model.password_min_numeric_chars,
            password_min_special_chars=model.password_min_special_chars,
            password_min_age_days=model.password_min_age_days,
            password_max_age_days=model.password_max_age_days,
            password_max_retries=model.password_max_retries,
            password_lockout_time_mins=model.password_lockout_time_mins,
            password_history=model.password_history,
            name=model.name,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PasswordPolicy.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PasswordPolicy object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PasswordPolicyModel:
        """Create an instance of PasswordPolicy from a dict.

        This method constructs a PasswordPolicy object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PasswordPolicy
            A PasswordPolicy object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PasswordPolicy.from_dict(obj))


PasswordPolicy._model_class = PasswordPolicyModel
