"""
Snowflake Pipe API.

The Snowflake Pipe API is a REST API that you can use to access, update, and perform certain actions on Pipe resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated


class Pipe(BaseModel):
    """A model object representing the Pipe resource.

    Constructs an object of type Pipe with the provided properties.

    Parameters
    __________
    name : str
        Name of the pipe
    copy_statement : str
        COPY INTO <table> statement used to load data from queued files into a Snowflake table. This statement serves as the text/definition for the pipe and is displayed in the SHOW PIPES output
    comment : str, optional
        user comment associated to an object in the dictionary
    auto_ingest : bool, optional
        TRUE if all files from stage need to be auto-ingested
    error_integration : str, optional
        Link to integration object that point to a user provided Azure storage queue / SQS. When present,  errors (e.g. ingest failure for Snowpipe or a user task failure or replication failure) will be sent to this queue to notify customers
    aws_sns_topic : str, optional
        Optional, if provided, auto_ingest pipe will only receive messages from this SNS topic.
    integration : str, optional
        Link to integration object that ties a user provided storage queue to an auto_ingest enabled pipe. Required for auto_ingest to work on azure.
    created_on : datetime, optional
        Date and time when the pipe was created — **Read-only:** *any user-provided value will be ignored.*
    database_name : str, optional
        Database in which the pipe is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the pipe is stored — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the pipe — **Read-only:** *any user-provided value will be ignored.*
    pattern : str, optional
        PATTERN copy option value in the COPY INTO <table> statement in the pipe definition, if the copy option was specified — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the pipe — **Read-only:** *any user-provided value will be ignored.*
    invalid_reason : str, optional
        Displays some detailed information for your pipes that may have issues — **Read-only:** *any user-provided value will be ignored.*
    budget : str, optional
        Name of the budget if the pipe is monitored by a budget — **Read-only:** *any user-provided value will be ignored.*
    """

    name: StrictStr

    comment: Optional[StrictStr] = None

    auto_ingest: Optional[StrictBool] = None

    error_integration: Optional[StrictStr] = None

    aws_sns_topic: Optional[StrictStr] = None

    integration: Optional[StrictStr] = None

    copy_statement: Annotated[str, Field(strict=True)]

    created_on: Optional[datetime] = None

    database_name: Optional[StrictStr] = None

    schema_name: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    pattern: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    invalid_reason: Optional[StrictStr] = None

    budget: Optional[StrictStr] = None

    __properties = [
        "name",
        "comment",
        "auto_ingest",
        "error_integration",
        "aws_sns_topic",
        "integration",
        "copy_statement",
        "created_on",
        "database_name",
        "schema_name",
        "owner",
        "pattern",
        "owner_role_type",
        "invalid_reason",
        "budget",
    ]

    @field_validator("copy_statement")
    def copy_statement_validate_regular_expression(cls, v):
        if not re.match(r"""(?i)^COPY INTO .*""", v):
            raise ValueError(r"""must validate the regular expression /(?i)^COPY INTO .*/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Pipe:
        """Create an instance of Pipe from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "owner",
                    "pattern",
                    "owner_role_type",
                    "invalid_reason",
                    "budget",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Pipe:
        """Create an instance of Pipe from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Pipe.model_validate(obj)

        _obj = Pipe.model_validate(
            {
                "name": obj.get("name"),
                "comment": obj.get("comment"),
                "auto_ingest": obj.get("auto_ingest"),
                "error_integration": obj.get("error_integration"),
                "aws_sns_topic": obj.get("aws_sns_topic"),
                "integration": obj.get("integration"),
                "copy_statement": obj.get("copy_statement"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "pattern": obj.get("pattern"),
                "owner_role_type": obj.get("owner_role_type"),
                "invalid_reason": obj.get("invalid_reason"),
                "budget": obj.get("budget"),
            }
        )

        return _obj


class PipeModel:
    def __init__(
        self,
        name: str,
        copy_statement: str,
        # optional properties
        comment: Optional[str] = None,
        auto_ingest: Optional[bool] = None,
        error_integration: Optional[str] = None,
        aws_sns_topic: Optional[str] = None,
        integration: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        pattern: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        invalid_reason: Optional[str] = None,
        budget: Optional[str] = None,
    ):
        """A model object representing the Pipe resource.

        Constructs an object of type Pipe with the provided properties.

        Parameters
        __________
        name : str
            Name of the pipe
        copy_statement : str
            COPY INTO <table> statement used to load data from queued files into a Snowflake table. This statement serves as the text/definition for the pipe and is displayed in the SHOW PIPES output
        comment : str, optional
            user comment associated to an object in the dictionary
        auto_ingest : bool, optional
            TRUE if all files from stage need to be auto-ingested
        error_integration : str, optional
            Link to integration object that point to a user provided Azure storage queue / SQS. When present,  errors (e.g. ingest failure for Snowpipe or a user task failure or replication failure) will be sent to this queue to notify customers
        aws_sns_topic : str, optional
            Optional, if provided, auto_ingest pipe will only receive messages from this SNS topic.
        integration : str, optional
            Link to integration object that ties a user provided storage queue to an auto_ingest enabled pipe. Required for auto_ingest to work on azure.
        created_on : datetime, optional
            Date and time when the pipe was created.
        database_name : str, optional
            Database in which the pipe is stored
        schema_name : str, optional
            Schema in which the pipe is stored
        owner : str, optional
            Role that owns the pipe
        pattern : str, optional
            PATTERN copy option value in the COPY INTO <table> statement in the pipe definition, if the copy option was specified.
        owner_role_type : str, optional
            The type of role that owns the pipe
        invalid_reason : str, optional
            Displays some detailed information for your pipes that may have issues
        budget : str, optional
            Name of the budget if the pipe is monitored by a budget
        """
        self.name = name
        self.comment = comment
        self.auto_ingest = auto_ingest
        self.error_integration = error_integration
        self.aws_sns_topic = aws_sns_topic
        self.integration = integration
        self.copy_statement = copy_statement
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.pattern = pattern
        self.owner_role_type = owner_role_type
        self.invalid_reason = invalid_reason
        self.budget = budget

    __properties = [
        "name",
        "comment",
        "auto_ingest",
        "error_integration",
        "aws_sns_topic",
        "integration",
        "copy_statement",
        "created_on",
        "database_name",
        "schema_name",
        "owner",
        "pattern",
        "owner_role_type",
        "invalid_reason",
        "budget",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Pipe(
            name=self.name,
            comment=self.comment,
            auto_ingest=self.auto_ingest,
            error_integration=self.error_integration,
            aws_sns_topic=self.aws_sns_topic,
            integration=self.integration,
            copy_statement=self.copy_statement,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            pattern=self.pattern,
            owner_role_type=self.owner_role_type,
            invalid_reason=self.invalid_reason,
            budget=self.budget,
        )

    @classmethod
    def _from_model(cls, model) -> PipeModel:
        return PipeModel(
            name=model.name,
            comment=model.comment,
            auto_ingest=model.auto_ingest,
            error_integration=model.error_integration,
            aws_sns_topic=model.aws_sns_topic,
            integration=model.integration,
            copy_statement=model.copy_statement,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            pattern=model.pattern,
            owner_role_type=model.owner_role_type,
            invalid_reason=model.invalid_reason,
            budget=model.budget,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Pipe.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Pipe object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PipeModel:
        """Create an instance of Pipe from a dict.

        This method constructs a Pipe object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Pipe
            A Pipe object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Pipe.from_dict(obj))


Pipe._model_class = PipeModel
