"""
Snowflake Secret API.

The Snowflake Secret API is a REST API that you can use to access, update, and perform certain actions on Secret resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, ClassVar, Dict, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated

import snowflake.core.secret._generated.models

from snowflake.core.secret._generated.models import *  # noqa: F403


class Secret(BaseModel):
    """A model object representing the Secret resource.

    Constructs an object of type Secret with the provided properties.

    Parameters
    __________
    name : str
        Name of the secret
    comment : str, optional
        user comment associated to an object in the dictionary
    created_on : datetime, optional
        Date and time when the secret was created — **Read-only:** *any user-provided value will be ignored.*
    database_name : str, optional
        Database in which the secret is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the secret is stored — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the secret — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the secret — **Read-only:** *any user-provided value will be ignored.*
    """

    comment: Optional[StrictStr] = None

    name: Annotated[str, Field(strict=True)]

    created_on: Optional[datetime] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[StrictStr] = None

    __properties = ["type", "comment", "name", "created_on", "database_name", "schema_name", "owner", "owner_role_type"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "CLOUD_PROVIDER_TOKEN": "CloudProviderTokenSecret",
        "GENERIC_STRING": "GenericStringSecret",
        "JWT_KEY_PAIR": "JwtKeyPairSecret",
        "OAUTH2": "Oauth2Secret",
        "PASSWORD": "PasswordSecret",
        "SYMMETRIC_KEY": "SymmetricKeySecret",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        "CloudProviderTokenSecret": "CLOUD_PROVIDER_TOKEN",
        "GenericStringSecret": "GENERIC_STRING",
        "JwtKeyPairSecret": "JWT_KEY_PAIR",
        "Oauth2Secret": "OAUTH2",
        "PasswordSecret": "PASSWORD",
        "SymmetricKeySecret": "SYMMETRIC_KEY",
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        CloudProviderTokenSecret,
        GenericStringSecret,
        JwtKeyPairSecret,
        Oauth2Secret,
        PasswordSecret,
        SymmetricKeySecret,
    ]:
        """Create an instance of Secret from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "owner",
                    "owner_role_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        CloudProviderTokenSecret,
        GenericStringSecret,
        JwtKeyPairSecret,
        Oauth2Secret,
        PasswordSecret,
        SymmetricKeySecret,
    ]:
        """Create an instance of Secret from a dict."""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(snowflake.core.secret._generated.models, object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "Secret failed to lookup discriminator value from "
                + json.dumps(obj)
                + ". Discriminator property name: "
                + cls.__discriminator_property_name
                + ", mapping: "
                + json.dumps(cls.__discriminator_value_class_map)
            )


class SecretModel:
    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the Secret resource.

        Constructs an object of type Secret with the provided properties.

        Parameters
        __________
        name : str
            Name of the secret
        comment : str, optional
            user comment associated to an object in the dictionary
        created_on : datetime, optional
            Date and time when the secret was created.
        database_name : str, optional
            Database in which the secret is stored
        schema_name : str, optional
            Schema in which the secret is stored
        owner : str, optional
            Role that owns the secret
        owner_role_type : str, optional
            The type of role that owns the secret
        """
        self.comment = comment
        self.name = name
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = ["type", "comment", "name", "created_on", "database_name", "schema_name", "owner", "owner_role_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Secret(
            comment=self.comment,
            name=self.name,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> SecretModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Create a dictionary of the properties from a Secret.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Secret object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        CloudProviderTokenSecretModel,
        GenericStringSecretModel,
        JwtKeyPairSecretModel,
        Oauth2SecretModel,
        PasswordSecretModel,
        SymmetricKeySecretModel,
    ]:
        """Create an instance of Secret from a dict.

        This method constructs a Secret object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Secret
            A Secret object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Secret.from_dict(obj))


Secret._model_class = SecretModel
