"""
Snowflake Services API.

The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class ServiceRole(BaseModel):
    """A model object representing the ServiceRole resource.

    Constructs an object of type ServiceRole with the provided properties.

    Parameters
    __________
    created_on : datetime, optional
        Date and time when the service role was created — **Read-only:** *any user-provided value will be ignored.*
    name : str, optional
        Service role name — **Read-only:** *any user-provided value will be ignored.*
    comment : str, optional
        Comment, if any, for the service role — **Read-only:** *any user-provided value will be ignored.*
    """

    created_on: Optional[datetime] = None

    name: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    __properties = ["created_on", "name", "comment"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceRole:
        """Create an instance of ServiceRole from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "name",
                    "comment",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceRole:
        """Create an instance of ServiceRole from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceRole.model_validate(obj)

        _obj = ServiceRole.model_validate(
            {
                "created_on": obj.get("created_on"),
                "name": obj.get("name"),
                "comment": obj.get("comment"),
            }
        )

        return _obj


class ServiceRoleModel:
    def __init__(
        self,  # optional properties
        created_on: Optional[datetime] = None,
        name: Optional[str] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the ServiceRole resource.

        Constructs an object of type ServiceRole with the provided properties.

        Parameters
        __________
        created_on : datetime, optional
            Date and time when the service role was created
        name : str, optional
            Service role name
        comment : str, optional
            Comment, if any, for the service role
        """
        self.created_on = created_on
        self.name = name
        self.comment = comment

    __properties = ["created_on", "name", "comment"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceRole(
            created_on=self.created_on,
            name=self.name,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceRoleModel:
        return ServiceRoleModel(
            created_on=model.created_on,
            name=model.name,
            comment=model.comment,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ServiceRole.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceRole object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceRoleModel:
        """Create an instance of ServiceRole from a dict.

        This method constructs a ServiceRole object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceRole
            A ServiceRole object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceRole.from_dict(obj))


ServiceRole._model_class = ServiceRoleModel
