"""
Snowflake Spark Connect API.

The Snowflake Spark Connect API is a REST API that you can use to access, update, and perform certain actions on Spark Connect resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import json
import logging
import os
import re
import tempfile

from concurrent.futures import Future
from datetime import date, datetime
from typing import Literal, Union, overload

from dateutil.parser import parse
from pydantic import StrictBytes, StrictStr, validate_call

import snowflake.core._http_requests

from snowflake.core._generated import rest
from snowflake.core._generated.api_client import ApiClient
from snowflake.core._internal.utils import is_running_inside_stored_procedure
from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError,
    _APIValueError,
)
from snowflake.core.spark_connect._generated import models


logger = logging.getLogger(__name__)


class SparkConnectApi:
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = "spark_connect"
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default()

    @property
    def api_client(self):
        return self._api_client

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if isinstance(klass, str):
            if klass.startswith("Iterable["):
                sub_kls = re.match(r"Iterable\[(.*)]", klass).group(1)
                return [self.__deserialize(sub_data, sub_kls) for sub_data in data]

            if klass.startswith("Dict["):
                sub_kls = re.match(r"Dict\[([^,]*), (.*)]", klass).group(2)
                return {k: self.__deserialize(v, sub_kls) for k, v in data.items()}

            # convert str to class
            if klass in snowflake.core._http_requests.NATIVE_TYPES_MAPPING:
                klass = snowflake.core._http_requests.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in snowflake.core._http_requests.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:  # noqa: E721
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def __deserialize_file(self, response):
        """Deserializes body to file.

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.api_client.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=f"Failed to parse `{string}` as date object")

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=(f"Failed to parse `{string}` as datetime object"))

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        return klass.from_dict(data)

    @overload
    def add_artifacts(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def add_artifacts(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def add_artifacts(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def add_artifacts(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about the added artifacts.  # noqa: E501

        Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about the added artifacts.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.add_artifacts(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.add_artifacts_with_http_info(body, **kwargs)

    @validate_call
    def add_artifacts_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about the added artifacts.  # noqa: E501

        Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about the added artifacts.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.add_artifacts_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method add_artifacts")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/add-artifacts",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def analyze_plan(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def analyze_plan(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def analyze_plan(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def analyze_plan(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""Analyzes a query and return a [[AnalyzeResponse]] containing metadata about the query.  # noqa: E501

        Analyzes a query and return a [[AnalyzeResponse]] containing metadata about the query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.analyze_plan(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.analyze_plan_with_http_info(body, **kwargs)

    @validate_call
    def analyze_plan_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""Analyzes a query and return a [[AnalyzeResponse]] containing metadata about the query.  # noqa: E501

        Analyzes a query and return a [[AnalyzeResponse]] containing metadata about the query.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.analyze_plan_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method analyze_plan")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/analyze-plan",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def artifact_status(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def artifact_status(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def artifact_status(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def artifact_status(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]  # noqa: E501

        Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.artifact_status(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.artifact_status_with_http_info(body, **kwargs)

    @validate_call
    def artifact_status_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]  # noqa: E501

        Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.artifact_status_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method artifact_status")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/artifact-status",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def config(self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs) -> bytearray: ...

    @overload
    def config(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def config(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def config(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.  # noqa: E501

        Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.config(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.config_with_http_info(body, **kwargs)

    @validate_call
    def config_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.  # noqa: E501

        Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.config_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method config")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/config",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def execute_plan(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def execute_plan(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def execute_plan(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def execute_plan(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.  # noqa: E501

        Executes a request that contains the query and returns a stream of [[ExecutePlanResponse]].  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_plan(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.execute_plan_with_http_info(body, **kwargs)

    @validate_call
    def execute_plan_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.  # noqa: E501

        Executes a request that contains the query and returns a stream of [[ExecutePlanResponse]].  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_plan_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method execute_plan")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/execute-plan",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def interrupt(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def interrupt(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def interrupt(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def interrupt(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""Interrupts running executions  # noqa: E501

        Interrupts running executions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.interrupt(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.interrupt_with_http_info(body, **kwargs)

    @validate_call
    def interrupt_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""Interrupts running executions  # noqa: E501

        Interrupts running executions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.interrupt_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method interrupt")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/interrupt",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def pull_request(self, body: StrictStr, async_req: Literal[False] = False, **kwargs) -> str: ...

    @overload
    def pull_request(self, body: StrictStr, async_req: Literal[True] = True, **kwargs) -> Future[str]: ...

    @overload
    def pull_request(self, body: StrictStr, async_req: bool = False, **kwargs) -> Union[str, Future[str]]: ...

    @validate_call
    def pull_request(self, body: StrictStr, **kwargs) -> Union[str, Future[str]]:
        r"""It is used for sproc dataframe processor to pull Spark request from GS.  # noqa: E501

        Get the next Spark request.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.pull_request(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[str, Future[str]]
        """
        kwargs["_return_http_data_only"] = True
        return self.pull_request_with_http_info(body, **kwargs)

    @validate_call
    def pull_request_with_http_info(self, body: StrictStr, **kwargs):
        r"""It is used for sproc dataframe processor to pull Spark request from GS.  # noqa: E501

        Get the next Spark request.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.pull_request_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[str, Future[str]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method pull_request")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "str",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/pull-request",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def push_response(self, body: StrictStr, async_req: Literal[False] = False, **kwargs) -> str: ...

    @overload
    def push_response(self, body: StrictStr, async_req: Literal[True] = True, **kwargs) -> Future[str]: ...

    @overload
    def push_response(self, body: StrictStr, async_req: bool = False, **kwargs) -> Union[str, Future[str]]: ...

    @validate_call
    def push_response(self, body: StrictStr, **kwargs) -> Union[str, Future[str]]:
        r"""It is used for sproc dataframe processor to push Spark response to GS.  # noqa: E501

        Executes a request from sproc that contains the Spark response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.push_response(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[str, Future[str]]
        """
        kwargs["_return_http_data_only"] = True
        return self.push_response_with_http_info(body, **kwargs)

    @validate_call
    def push_response_with_http_info(self, body: StrictStr, **kwargs):
        r"""It is used for sproc dataframe processor to push Spark response to GS.  # noqa: E501

        Executes a request from sproc that contains the Spark response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.push_response_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[str, Future[str]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method push_response")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "str",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/push-response",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def reattach_execute(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def reattach_execute(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def reattach_execute(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def reattach_execute(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""The ExecutePlan must have been started with ReattachOptions.reattachable=true. If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to continue. If there is a ResultComplete, the client should use ReleaseExecute with  # noqa: E501

        Reattach to an existing re-attachable execution.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.reattach_execute(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.reattach_execute_with_http_info(body, **kwargs)

    @validate_call
    def reattach_execute_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""The ExecutePlan must have been started with ReattachOptions.reattachable=true. If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to continue. If there is a ResultComplete, the client should use ReleaseExecute with  # noqa: E501

        Reattach to an existing re-attachable execution.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.reattach_execute_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method reattach_execute")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/reattach-execute",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def release_execute(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[False] = False, **kwargs
    ) -> bytearray: ...

    @overload
    def release_execute(
        self, body: Union[StrictBytes, StrictStr], async_req: Literal[True] = True, **kwargs
    ) -> Future[bytearray]: ...

    @overload
    def release_execute(
        self, body: Union[StrictBytes, StrictStr], async_req: bool = False, **kwargs
    ) -> Union[bytearray, Future[bytearray]]: ...

    @validate_call
    def release_execute(self, body: Union[StrictBytes, StrictStr], **kwargs) -> Union[bytearray, Future[bytearray]]:
        r"""The ExecutePlan must have been started with ReattachOptions.reattachable=true. Non re-attachable executions are released automatically and immediately after the ExecutePlan RPC and ReleaseExecute may not be used.  # noqa: E501

        Release an re-attachable execution, or parts thereof.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.release_execute(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[bytearray, Future[bytearray]]
        """
        kwargs["_return_http_data_only"] = True
        return self.release_execute_with_http_info(body, **kwargs)

    @validate_call
    def release_execute_with_http_info(self, body: Union[StrictBytes, StrictStr], **kwargs):
        r"""The ExecutePlan must have been started with ReattachOptions.reattachable=true. Non re-attachable executions are released automatically and immediately after the ExecutePlan RPC and ReleaseExecute may not be used.  # noqa: E501

        Release an re-attachable execution, or parts thereof.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.release_execute_with_http_info(body, async_req=True)
        >>> result = future.result()
        :param body: (required)
        :type body: bytearray
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[bytearray, Future[bytearray]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method release_execute")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["body"] is not None:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/octet-stream"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "bytearray",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/spark-connect/release-execute",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )
