"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import warnings

from typing import TYPE_CHECKING, Any, Iterator, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.streamlit._generated.models.add_live_version_streamlit_request import AddLiveVersionStreamlitRequest
from snowflake.core.streamlit._generated.models.add_version_from_git_streamlit_request import (
    AddVersionFromGitStreamlitRequest,
)
from snowflake.core.streamlit._generated.models.add_version_streamlit_request import AddVersionStreamlitRequest
from snowflake.core.streamlit._generated.models.commit_streamlit_request import CommitStreamlitRequest
from snowflake.core.streamlit._generated.models.streamlit import Streamlit
from snowflake.core.streamlit._generated.models.streamlit_push_options import StreamlitPushOptions

from .streamlit_api import StreamlitApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class StreamlitCollectionBase(SchemaObjectCollectionParent["StreamlitResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = StreamlitApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(self, streamlit: Streamlit, mode: Optional[Union[CreateMode, str]] = None) -> "StreamlitResource":  # noqa: F821
        """Create a Streamlit.

        Parameters
        __________
        streamlit: Streamlit
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_streamlit(
            self.database.name,
            self.schema.name,
            streamlit=streamlit,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(streamlit), self)
        return self._ref_class(streamlit.name, self)

    @api_telemetry
    def create_async(
        self, streamlit: Streamlit, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["StreamlitResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_streamlit(
            self.database.name,
            self.schema.name,
            streamlit=streamlit,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(future, lambda _: self._ref_class(get_function_name_with_args(streamlit), self))
        return PollingOperation(
            future, lambda _: self._ref_class(streamlit if isinstance(streamlit, str) else streamlit.name, self)
        )

    @api_telemetry
    def iter(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        from_name: Optional[str] = None,
        show_limit: Optional[int] = None,
    ) -> Iterator[Streamlit]:
        """List Streamlits.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        starts_with: str
             Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        limit: int
             Parameter to limit the maximum number of rows returned by a command.
        from_name: str
             Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        resources = self._api.list_streamlits(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            from_name=from_name,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        from_name: Optional[str] = None,
        show_limit: Optional[int] = None,
    ) -> PollingOperation[Iterator[Streamlit]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        future = self._api.list_streamlits(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            from_name=from_name,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class StreamlitResourceBase(SchemaObjectReferenceMixin["StreamlitCollection"]):
    _collection_class: StreamlitCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: StreamlitCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def abort(
        self,
    ) -> None:
        """Abort live version.

        Parameters
        __________
        """
        self.collection._api.abort_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def abort_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`abort`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.abort_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def add_live_version(
        self,
        from_last: Optional[bool] = None,
        add_live_version_streamlit_request: Optional[AddLiveVersionStreamlitRequest] = None,
    ) -> None:
        """Add live version.

        Parameters
        __________
        from_last: bool
             Set the LIVE version to the LAST version of the Streamlit.
        add_live_version_streamlit_request: AddLiveVersionStreamlitRequest
        """
        self.collection._api.add_live_version_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            from_last=from_last,
            add_live_version_streamlit_request=add_live_version_streamlit_request,
            async_req=False,
        )

    @api_telemetry
    def add_live_version_async(
        self,
        from_last: Optional[bool] = None,
        add_live_version_streamlit_request: Optional[AddLiveVersionStreamlitRequest] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`add_live_version`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.add_live_version_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            from_last=from_last,
            add_live_version_streamlit_request=add_live_version_streamlit_request,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def add_version_from_git(
        self,
        add_version_from_git_streamlit_request: AddVersionFromGitStreamlitRequest,
    ) -> None:
        """Add version from Git.

        Parameters
        __________
        add_version_from_git_streamlit_request: AddVersionFromGitStreamlitRequest
             (required)
        """
        self.collection._api.add_version_from_git_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            add_version_from_git_streamlit_request=add_version_from_git_streamlit_request,
            async_req=False,
        )

    @api_telemetry
    def add_version_from_git_async(
        self,
        add_version_from_git_streamlit_request: AddVersionFromGitStreamlitRequest,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`add_version_from_git`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.add_version_from_git_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            add_version_from_git_streamlit_request=add_version_from_git_streamlit_request,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def add_version(
        self,
        add_version_streamlit_request: AddVersionStreamlitRequest,
    ) -> None:
        """Add version from source.

        Parameters
        __________
        add_version_streamlit_request: AddVersionStreamlitRequest
             (required)
        """
        self.collection._api.add_version_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            add_version_streamlit_request=add_version_streamlit_request,
            async_req=False,
        )

    @api_telemetry
    def add_version_async(
        self,
        add_version_streamlit_request: AddVersionStreamlitRequest,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`add_version`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.add_version_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            add_version_streamlit_request=add_version_streamlit_request,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def commit(
        self,
        commit_streamlit_request: Optional[CommitStreamlitRequest] = None,
    ) -> None:
        """Commit live version.

        Parameters
        __________
        commit_streamlit_request: CommitStreamlitRequest
        """
        self.collection._api.commit_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            commit_streamlit_request=commit_streamlit_request,
            async_req=False,
        )

    @api_telemetry
    def commit_async(
        self,
        commit_streamlit_request: Optional[CommitStreamlitRequest] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`commit`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.commit_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            commit_streamlit_request=commit_streamlit_request,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def fetch(
        self,
    ) -> Streamlit:
        """Fetch a Streamlit.

        Parameters
        __________
        """
        return self.collection._api.fetch_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[Streamlit]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def pull(
        self,
    ) -> None:
        """Pull from Git.

        Parameters
        __________
        """
        self.collection._api.pull_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def pull_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`pull`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.pull_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def push(
        self,
        streamlit_push_options: StreamlitPushOptions,
    ) -> None:
        """Push to Git.

        Parameters
        __________
        streamlit_push_options: StreamlitPushOptions
             (required)
        """
        self.collection._api.push_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            streamlit_push_options=streamlit_push_options,
            async_req=False,
        )

    @api_telemetry
    def push_async(
        self,
        streamlit_push_options: StreamlitPushOptions,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`push`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.push_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            streamlit_push_options=streamlit_push_options,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def rename(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> None:
        """Rename a Streamlit.

        Parameters
        __________
        target_name: str
             Name of the target resource. (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        target_database: str
             Database of the target resource. Defaults to the source's database
        target_schema: str
             Schema of the target resource. Defaults to the source's schema
        """
        self.collection._api.rename_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=False,
        )

        self._rename_finalizer(target_name, target_schema, target_database)

    @api_telemetry
    def rename_async(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`rename`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.rename_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=True,
        )

        def finalize(_: Any) -> None:
            self._rename_finalizer(
                target_name=target_name, target_schema=target_schema, target_database=target_database
            )

        return PollingOperation(future, finalize)

    def _rename_finalizer(self, target_name: str, target_schema: Optional[str], target_database: Optional[str]) -> None:
        """Finalizer for rename operation."""
        self._set_new_name(target_name)
        if target_database is None:
            target_database = self.database.name
        if target_schema is None:
            target_schema = self.schema.name

        # Schema level resource
        if target_database != self.database.name or target_schema != self.schema.name:
            self.collection = getattr(self.root.databases[target_database].schemas[target_schema], self._plural_name)

    @api_telemetry
    def undrop(
        self,
    ) -> None:
        """Undrop a Streamlit.

        Parameters
        __________
        """
        self.collection._api.undrop_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def undrop_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`undrop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.undrop_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a Streamlit.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_streamlit(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
