"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict

from snowflake.core.streamlit._generated.models.add_live_version_streamlit_request_version import (
    AddLiveVersionStreamlitRequestVersion,
    AddLiveVersionStreamlitRequestVersionModel,
)


class AddLiveVersionStreamlitRequest(BaseModel):
    """A model object representing the AddLiveVersionStreamlitRequest resource.

    Constructs an object of type AddLiveVersionStreamlitRequest with the provided properties.

    Parameters
    __________
    version : AddLiveVersionStreamlitRequestVersion, optional
    """

    version: Optional[AddLiveVersionStreamlitRequestVersion] = None

    __properties = ["version"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddLiveVersionStreamlitRequest:
        """Create an instance of AddLiveVersionStreamlitRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict["version"] = self.version.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AddLiveVersionStreamlitRequest:
        """Create an instance of AddLiveVersionStreamlitRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddLiveVersionStreamlitRequest.model_validate(obj)

        _obj = AddLiveVersionStreamlitRequest.model_validate(
            {
                "version": AddLiveVersionStreamlitRequestVersion.from_dict(obj.get("version"))
                if obj.get("version") is not None
                else None,
            }
        )

        return _obj


class AddLiveVersionStreamlitRequestModel:
    def __init__(
        self,  # optional properties
        version: Optional[AddLiveVersionStreamlitRequestVersion] = None,
    ):
        """A model object representing the AddLiveVersionStreamlitRequest resource.

        Constructs an object of type AddLiveVersionStreamlitRequest with the provided properties.

        Parameters
        __________
        version : AddLiveVersionStreamlitRequestVersion, optional
        """
        self.version = version

    __properties = ["version"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AddLiveVersionStreamlitRequest(
            version=self.version._to_model() if self.version is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> AddLiveVersionStreamlitRequestModel:
        return AddLiveVersionStreamlitRequestModel(
            version=AddLiveVersionStreamlitRequestVersionModel._from_model(model.version) if model.version else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AddLiveVersionStreamlitRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AddLiveVersionStreamlitRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AddLiveVersionStreamlitRequestModel:
        """Create an instance of AddLiveVersionStreamlitRequest from a dict.

        This method constructs a AddLiveVersionStreamlitRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AddLiveVersionStreamlitRequest
            A AddLiveVersionStreamlitRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AddLiveVersionStreamlitRequest.from_dict(obj))


AddLiveVersionStreamlitRequest._model_class = AddLiveVersionStreamlitRequestModel
