"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class VersionDetailsStreamlit(BaseModel):
    """A model object representing the VersionDetailsStreamlit resource.

    Constructs an object of type VersionDetailsStreamlit with the provided properties.

    Parameters
    __________
    name : str, optional
        The last version name — **Read-only:** *any user-provided value will be ignored.*
    alias : str, optional
        The default/last version alias of a file-based entity — **Read-only:** *any user-provided value will be ignored.*
    location_url : str, optional
        The default/last version location — **Read-only:** *any user-provided value will be ignored.*
    source_location_uri : str, optional
        The default/last version source location — **Read-only:** *any user-provided value will be ignored.*
    git_commit_hash : str, optional
        The default/last version Git commit — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Optional[StrictStr] = None

    alias: Optional[StrictStr] = None

    location_url: Optional[StrictStr] = None

    source_location_uri: Optional[StrictStr] = None

    git_commit_hash: Optional[StrictStr] = None

    __properties = ["name", "alias", "location_url", "source_location_uri", "git_commit_hash"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VersionDetailsStreamlit:
        """Create an instance of VersionDetailsStreamlit from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "name",
                    "alias",
                    "location_url",
                    "source_location_uri",
                    "git_commit_hash",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> VersionDetailsStreamlit:
        """Create an instance of VersionDetailsStreamlit from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VersionDetailsStreamlit.model_validate(obj)

        _obj = VersionDetailsStreamlit.model_validate(
            {
                "name": obj.get("name"),
                "alias": obj.get("alias"),
                "location_url": obj.get("location_url"),
                "source_location_uri": obj.get("source_location_uri"),
                "git_commit_hash": obj.get("git_commit_hash"),
            }
        )

        return _obj


class VersionDetailsStreamlitModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        alias: Optional[str] = None,
        location_url: Optional[str] = None,
        source_location_uri: Optional[str] = None,
        git_commit_hash: Optional[str] = None,
    ):
        """A model object representing the VersionDetailsStreamlit resource.

        Constructs an object of type VersionDetailsStreamlit with the provided properties.

        Parameters
        __________
        name : str, optional
            The last version name
        alias : str, optional
            The default/last version alias of a file-based entity.
        location_url : str, optional
            The default/last version location.
        source_location_uri : str, optional
            The default/last version source location.
        git_commit_hash : str, optional
            The default/last version Git commit
        """
        self.name = name
        self.alias = alias
        self.location_url = location_url
        self.source_location_uri = source_location_uri
        self.git_commit_hash = git_commit_hash

    __properties = ["name", "alias", "location_url", "source_location_uri", "git_commit_hash"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return VersionDetailsStreamlit(
            name=self.name,
            alias=self.alias,
            location_url=self.location_url,
            source_location_uri=self.source_location_uri,
            git_commit_hash=self.git_commit_hash,
        )

    @classmethod
    def _from_model(cls, model) -> VersionDetailsStreamlitModel:
        return VersionDetailsStreamlitModel(
            name=model.name,
            alias=model.alias,
            location_url=model.location_url,
            source_location_uri=model.source_location_uri,
            git_commit_hash=model.git_commit_hash,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a VersionDetailsStreamlit.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the VersionDetailsStreamlit object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> VersionDetailsStreamlitModel:
        """Create an instance of VersionDetailsStreamlit from a dict.

        This method constructs a VersionDetailsStreamlit object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        VersionDetailsStreamlit
            A VersionDetailsStreamlit object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(VersionDetailsStreamlit.from_dict(obj))


VersionDetailsStreamlit._model_class = VersionDetailsStreamlitModel
