"""
Snowflake Table API.

The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr, field_validator

from snowflake.core.table._generated.models.constraint import Constraint, ConstraintModel
from snowflake.core.table._generated.models.table_column import TableColumn, TableColumnModel


class Table(BaseModel):
    """A model object representing the Table resource.

    Constructs an object of type Table with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the table, must be unique for the schema in which the table is created
    kind : str,  default 'PERMANENT'
        Table type - permanent, transient, or temporary
    cluster_by : list[str], optional
        Specifies one or more columns or column expressions in the table as the clustering key
    enable_schema_evolution : bool, optional
        Table has schema evolution enabled or disabled
    change_tracking : bool, optional
        Change tracking is enabled or disabled
    data_retention_time_in_days : int, optional
        Specifies the retention period for the table so that Time Travel actions SELECT, CLONE, UNDROP can be performed on historical data in the table
    max_data_extension_time_in_days : int, optional
        Specifies the retention period for the table so that Time Travel actions SELECT, CLONE, UNDROP can be performed on historical data in the table
    default_ddl_collation : str, optional
        Specifies a default collation specification for the columns in the table, including columns added to the table in the future
    columns : list[TableColumn], optional

    constraints : list[Constraint], optional

    comment : str, optional
        Comment for the table
    created_on : datetime, optional
        Date and time when the table was created — **Read-only:** *any user-provided value will be ignored.*
    database_name : str, optional
        Database in which the table is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the table is stored — **Read-only:** *any user-provided value will be ignored.*
    rows : int, optional
        Number of rows in the table. Returns NULL for external tables — **Read-only:** *any user-provided value will be ignored.*
    bytes : int, optional
        Number of bytes that will be scanned if the entire table is scanned in a query. Note that this number may be different than the number of actual physical bytes stored on-disk for the table — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the table — **Read-only:** *any user-provided value will be ignored.*
    dropped_on : datetime, optional
        Date and time when the table was dropped — **Read-only:** *any user-provided value will be ignored.*
    automatic_clustering : bool, optional
        If Automatic Clustering is enabled for your account, specifies whether it is explicitly enabled or disabled for the table — **Read-only:** *any user-provided value will be ignored.*
    search_optimization : bool, optional
        If ON, the table has the search optimization service enabled — **Read-only:** *any user-provided value will be ignored.*
    search_optimization_progress : int, optional
        Percentage of the table that has been optimized for search — **Read-only:** *any user-provided value will be ignored.*
    search_optimization_bytes : int, optional
        Number of additional bytes of storage that the search optimization service consumes for this table — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the object — **Read-only:** *any user-provided value will be ignored.*
    budget : str, optional
        Name of the budget if the object is monitored by a budget — **Read-only:** *any user-provided value will be ignored.*
    table_type : str, optional
        Type of the table — **Read-only:** *any user-provided value will be ignored.*
    """

    name: StrictStr

    kind: Optional[StrictStr] = "PERMANENT"

    cluster_by: Optional[List[StrictStr]] = None

    enable_schema_evolution: Optional[StrictBool] = None

    change_tracking: Optional[StrictBool] = None

    data_retention_time_in_days: Optional[StrictInt] = None

    max_data_extension_time_in_days: Optional[StrictInt] = None

    default_ddl_collation: Optional[StrictStr] = None

    columns: Optional[List[TableColumn]] = None

    constraints: Optional[List[Constraint]] = None

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    database_name: Optional[StrictStr] = None

    schema_name: Optional[StrictStr] = None

    rows: Optional[StrictInt] = None

    bytes: Optional[StrictInt] = None

    owner: Optional[StrictStr] = None

    dropped_on: Optional[datetime] = None

    automatic_clustering: Optional[StrictBool] = None

    search_optimization: Optional[StrictBool] = None

    search_optimization_progress: Optional[StrictInt] = None

    search_optimization_bytes: Optional[StrictInt] = None

    owner_role_type: Optional[StrictStr] = None

    budget: Optional[StrictStr] = None

    table_type: Optional[StrictStr] = None

    __properties = [
        "name",
        "kind",
        "cluster_by",
        "enable_schema_evolution",
        "change_tracking",
        "data_retention_time_in_days",
        "max_data_extension_time_in_days",
        "default_ddl_collation",
        "columns",
        "constraints",
        "comment",
        "created_on",
        "database_name",
        "schema_name",
        "rows",
        "bytes",
        "owner",
        "dropped_on",
        "automatic_clustering",
        "search_optimization",
        "search_optimization_progress",
        "search_optimization_bytes",
        "owner_role_type",
        "budget",
        "table_type",
    ]

    @field_validator("kind")
    def kind_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("PERMANENT", "TRANSIENT", "TEMPORARY", "", "transient", "temporary"):
            raise ValueError(
                "must validate the enum values ('PERMANENT','TRANSIENT','TEMPORARY','','transient','temporary')"
            )
        return v

    @field_validator("table_type")
    def table_type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("NORMAL", "DYNAMIC", "EXTERNAL", "EVENT", "HYBRID", "ICEBERG", "IMMUTABLE"):
            raise ValueError(
                "must validate the enum values ('NORMAL','DYNAMIC','EXTERNAL','EVENT','HYBRID','ICEBERG','IMMUTABLE')"
            )
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Table:
        """Create an instance of Table from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "rows",
                    "bytes",
                    "owner",
                    "dropped_on",
                    "automatic_clustering",
                    "search_optimization",
                    "search_optimization_progress",
                    "search_optimization_bytes",
                    "owner_role_type",
                    "budget",
                    "table_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict["columns"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in constraints (list)
        _items = []
        if self.constraints:
            for _item in self.constraints:
                if _item:
                    _items.append(_item.to_dict())
            _dict["constraints"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Table:
        """Create an instance of Table from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Table.model_validate(obj)

        _obj = Table.model_validate(
            {
                "name": obj.get("name"),
                "kind": obj.get("kind") if obj.get("kind") is not None else "PERMANENT",
                "cluster_by": obj.get("cluster_by"),
                "enable_schema_evolution": obj.get("enable_schema_evolution"),
                "change_tracking": obj.get("change_tracking"),
                "data_retention_time_in_days": obj.get("data_retention_time_in_days"),
                "max_data_extension_time_in_days": obj.get("max_data_extension_time_in_days"),
                "default_ddl_collation": obj.get("default_ddl_collation"),
                "columns": [TableColumn.from_dict(_item) for _item in obj.get("columns")]
                if obj.get("columns") is not None
                else None,
                "constraints": [Constraint.from_dict(_item) for _item in obj.get("constraints")]
                if obj.get("constraints") is not None
                else None,
                "comment": obj.get("comment"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "rows": obj.get("rows"),
                "bytes": obj.get("bytes"),
                "owner": obj.get("owner"),
                "dropped_on": obj.get("dropped_on"),
                "automatic_clustering": obj.get("automatic_clustering"),
                "search_optimization": obj.get("search_optimization"),
                "search_optimization_progress": obj.get("search_optimization_progress"),
                "search_optimization_bytes": obj.get("search_optimization_bytes"),
                "owner_role_type": obj.get("owner_role_type"),
                "budget": obj.get("budget"),
                "table_type": obj.get("table_type"),
            }
        )

        return _obj


class TableModel:
    def __init__(
        self,
        name: str,
        # optional properties
        kind: Optional[str] = "PERMANENT",
        cluster_by: Optional[list[str]] = None,
        enable_schema_evolution: Optional[bool] = None,
        change_tracking: Optional[bool] = None,
        data_retention_time_in_days: Optional[int] = None,
        max_data_extension_time_in_days: Optional[int] = None,
        default_ddl_collation: Optional[str] = None,
        columns: Optional[list[TableColumn]] = None,
        constraints: Optional[list[Constraint]] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        rows: Optional[int] = None,
        bytes: Optional[int] = None,
        owner: Optional[str] = None,
        dropped_on: Optional[datetime] = None,
        automatic_clustering: Optional[bool] = None,
        search_optimization: Optional[bool] = None,
        search_optimization_progress: Optional[int] = None,
        search_optimization_bytes: Optional[int] = None,
        owner_role_type: Optional[str] = None,
        budget: Optional[str] = None,
        table_type: Optional[str] = None,
    ):
        """A model object representing the Table resource.

        Constructs an object of type Table with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the table, must be unique for the schema in which the table is created
        kind : str,  default 'PERMANENT'
            Table type - permanent, transient, or temporary
        cluster_by : list[str], optional
            Specifies one or more columns or column expressions in the table as the clustering key
        enable_schema_evolution : bool, optional
            Table has schema evolution enabled or disabled
        change_tracking : bool, optional
            Change tracking is enabled or disabled
        data_retention_time_in_days : int, optional
            Specifies the retention period for the table so that Time Travel actions SELECT, CLONE, UNDROP can be performed on historical data in the table
        max_data_extension_time_in_days : int, optional
            Specifies the retention period for the table so that Time Travel actions SELECT, CLONE, UNDROP can be performed on historical data in the table
        default_ddl_collation : str, optional
            Specifies a default collation specification for the columns in the table, including columns added to the table in the future
        columns : list[TableColumn], optional

        constraints : list[Constraint], optional

        comment : str, optional
            Comment for the table
        created_on : datetime, optional
            Date and time when the table was created.
        database_name : str, optional
            Database in which the table is stored
        schema_name : str, optional
            Schema in which the table is stored
        rows : int, optional
            Number of rows in the table. Returns NULL for external tables.
        bytes : int, optional
            Number of bytes that will be scanned if the entire table is scanned in a query. Note that this number may be different than the number of actual physical bytes stored on-disk for the table
        owner : str, optional
            Role that owns the table
        dropped_on : datetime, optional
            Date and time when the table was dropped
        automatic_clustering : bool, optional
            If Automatic Clustering is enabled for your account, specifies whether it is explicitly enabled or disabled for the table.
        search_optimization : bool, optional
            If ON, the table has the search optimization service enabled
        search_optimization_progress : int, optional
            Percentage of the table that has been optimized for search.
        search_optimization_bytes : int, optional
            Number of additional bytes of storage that the search optimization service consumes for this table
        owner_role_type : str, optional
            The type of role that owns the object.
        budget : str, optional
            Name of the budget if the object is monitored by a budget
        table_type : str, optional
            Type of the table
        """
        self.name = name
        self.kind = kind
        self.cluster_by = cluster_by
        self.enable_schema_evolution = enable_schema_evolution
        self.change_tracking = change_tracking
        self.data_retention_time_in_days = data_retention_time_in_days
        self.max_data_extension_time_in_days = max_data_extension_time_in_days
        self.default_ddl_collation = default_ddl_collation
        self.columns = columns
        self.constraints = constraints
        self.comment = comment
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.rows = rows
        self.bytes = bytes
        self.owner = owner
        self.dropped_on = dropped_on
        self.automatic_clustering = automatic_clustering
        self.search_optimization = search_optimization
        self.search_optimization_progress = search_optimization_progress
        self.search_optimization_bytes = search_optimization_bytes
        self.owner_role_type = owner_role_type
        self.budget = budget
        self.table_type = table_type

    __properties = [
        "name",
        "kind",
        "cluster_by",
        "enable_schema_evolution",
        "change_tracking",
        "data_retention_time_in_days",
        "max_data_extension_time_in_days",
        "default_ddl_collation",
        "columns",
        "constraints",
        "comment",
        "created_on",
        "database_name",
        "schema_name",
        "rows",
        "bytes",
        "owner",
        "dropped_on",
        "automatic_clustering",
        "search_optimization",
        "search_optimization_progress",
        "search_optimization_bytes",
        "owner_role_type",
        "budget",
        "table_type",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Table(
            name=self.name,
            kind=self.kind,
            cluster_by=self.cluster_by,
            enable_schema_evolution=self.enable_schema_evolution,
            change_tracking=self.change_tracking,
            data_retention_time_in_days=self.data_retention_time_in_days,
            max_data_extension_time_in_days=self.max_data_extension_time_in_days,
            default_ddl_collation=self.default_ddl_collation,
            columns=[x._to_model() for x in self.columns] if self.columns is not None else None,
            constraints=[x._to_model() for x in self.constraints] if self.constraints is not None else None,
            comment=self.comment,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            rows=self.rows,
            bytes=self.bytes,
            owner=self.owner,
            dropped_on=self.dropped_on,
            automatic_clustering=self.automatic_clustering,
            search_optimization=self.search_optimization,
            search_optimization_progress=self.search_optimization_progress,
            search_optimization_bytes=self.search_optimization_bytes,
            owner_role_type=self.owner_role_type,
            budget=self.budget,
            table_type=self.table_type,
        )

    @classmethod
    def _from_model(cls, model) -> TableModel:
        return TableModel(
            name=model.name,
            kind=model.kind,
            cluster_by=model.cluster_by,
            enable_schema_evolution=model.enable_schema_evolution,
            change_tracking=model.change_tracking,
            data_retention_time_in_days=model.data_retention_time_in_days,
            max_data_extension_time_in_days=model.max_data_extension_time_in_days,
            default_ddl_collation=model.default_ddl_collation,
            columns=[TableColumnModel._from_model(x) for x in model.columns] if model.columns else None,
            constraints=[ConstraintModel._from_model(x) for x in model.constraints] if model.constraints else None,
            comment=model.comment,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            rows=model.rows,
            bytes=model.bytes,
            owner=model.owner,
            dropped_on=model.dropped_on,
            automatic_clustering=model.automatic_clustering,
            search_optimization=model.search_optimization,
            search_optimization_progress=model.search_optimization_progress,
            search_optimization_bytes=model.search_optimization_bytes,
            owner_role_type=model.owner_role_type,
            budget=model.budget,
            table_type=model.table_type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Table.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Table object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableModel:
        """Create an instance of Table from a dict.

        This method constructs a Table object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Table
            A Table object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Table.from_dict(obj))


Table._model_class = TableModel
