"""
Snowflake Catalog Integration API.

The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated


class TagReference(BaseModel):
    """A model object representing the TagReference resource.

    Constructs an object of type TagReference with the provided properties.

    Parameters
    __________
    tag_name : str
        The name of the tag.
    tag_database : str, optional
        The database in which the tag is defined.
    tag_schema : str, optional
        The schema in which the tag is defined.
    """

    tag_database: Optional[Annotated[str, Field(strict=True)]] = None

    tag_schema: Optional[Annotated[str, Field(strict=True)]] = None

    tag_name: Annotated[str, Field(strict=True)]

    __properties = ["tag_database", "tag_schema", "tag_name"]

    @field_validator("tag_database")
    def tag_database_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("tag_schema")
    def tag_schema_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("tag_name")
    def tag_name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TagReference:
        """Create an instance of TagReference from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TagReference:
        """Create an instance of TagReference from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TagReference.model_validate(obj)

        _obj = TagReference.model_validate(
            {
                "tag_database": obj.get("tag_database"),
                "tag_schema": obj.get("tag_schema"),
                "tag_name": obj.get("tag_name"),
            }
        )

        return _obj


class TagReferenceModel:
    def __init__(
        self,
        tag_name: str,
        # optional properties
        tag_database: Optional[str] = None,
        tag_schema: Optional[str] = None,
    ):
        """A model object representing the TagReference resource.

        Constructs an object of type TagReference with the provided properties.

        Parameters
        __________
        tag_name : str
            The name of the tag.
        tag_database : str, optional
            The database in which the tag is defined.
        tag_schema : str, optional
            The schema in which the tag is defined.
        """
        self.tag_database = tag_database
        self.tag_schema = tag_schema
        self.tag_name = tag_name

    __properties = ["tag_database", "tag_schema", "tag_name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TagReference(
            tag_database=self.tag_database,
            tag_schema=self.tag_schema,
            tag_name=self.tag_name,
        )

    @classmethod
    def _from_model(cls, model) -> TagReferenceModel:
        return TagReferenceModel(
            tag_database=model.tag_database,
            tag_schema=model.tag_schema,
            tag_name=model.tag_name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TagReference.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TagReference object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TagReferenceModel:
        """Create an instance of TagReference from a dict.

        This method constructs a TagReference object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TagReference
            A TagReference object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TagReference.from_dict(obj))


TagReference._model_class = TagReferenceModel
