"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class CreateAnalystEvalOptimizationResponse(BaseModel):
    """A model object representing the CreateAnalystEvalOptimizationResponse resource.

    Constructs an object of type CreateAnalystEvalOptimizationResponse with the provided properties.

    Parameters
    __________
    request_id : str, optional
        Unique request ID
    optimization_name : str, optional
        The fully-qualified name of the created optimization. Uses format SYSTEM_AI_OBS_ANALYST_EVAL_{view_name}.
    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    request_id: Optional[StrictStr] = None

    optimization_name: Optional[StrictStr] = None

    experimental: Optional[StrictStr] = None

    __properties = ["request_id", "optimization_name", "experimental"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateAnalystEvalOptimizationResponse:
        """Create an instance of CreateAnalystEvalOptimizationResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAnalystEvalOptimizationResponse:
        """Create an instance of CreateAnalystEvalOptimizationResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateAnalystEvalOptimizationResponse.model_validate(obj)

        _obj = CreateAnalystEvalOptimizationResponse.model_validate(
            {
                "request_id": obj.get("request_id"),
                "optimization_name": obj.get("optimization_name"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class CreateAnalystEvalOptimizationResponseModel:
    def __init__(
        self,  # optional properties
        request_id: Optional[str] = None,
        optimization_name: Optional[str] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the CreateAnalystEvalOptimizationResponse resource.

        Constructs an object of type CreateAnalystEvalOptimizationResponse with the provided properties.

        Parameters
        __________
        request_id : str, optional
            Unique request ID
        optimization_name : str, optional
            The fully-qualified name of the created optimization. Uses format SYSTEM_AI_OBS_ANALYST_EVAL_{view_name}.
        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.request_id = request_id
        self.optimization_name = optimization_name
        self.experimental = experimental

    __properties = ["request_id", "optimization_name", "experimental"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CreateAnalystEvalOptimizationResponse(
            request_id=self.request_id,
            optimization_name=self.optimization_name,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> CreateAnalystEvalOptimizationResponseModel:
        return CreateAnalystEvalOptimizationResponseModel(
            request_id=model.request_id,
            optimization_name=model.optimization_name,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CreateAnalystEvalOptimizationResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CreateAnalystEvalOptimizationResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAnalystEvalOptimizationResponseModel:
        """Create an instance of CreateAnalystEvalOptimizationResponse from a dict.

        This method constructs a CreateAnalystEvalOptimizationResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CreateAnalystEvalOptimizationResponse
            A CreateAnalystEvalOptimizationResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CreateAnalystEvalOptimizationResponse.from_dict(obj))


CreateAnalystEvalOptimizationResponse._model_class = CreateAnalystEvalOptimizationResponseModel
