"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.semantic_model_object import (
    SemanticModelObject,
    SemanticModelObjectModel,
)
from snowflake.core.cortex.analyst_service._generated.models.table_columns import TableColumns, TableColumnsModel


class GenerateFiltersAndMetricsSuggestionsRequest(BaseModel):
    """A model object representing the GenerateFiltersAndMetricsSuggestionsRequest resource.

    Constructs an object of type GenerateFiltersAndMetricsSuggestionsRequest with the provided properties.

    Parameters
    __________
    semantic_model : SemanticModelObject, optional

    tables : list[TableColumns], optional
        Tables and selected columns to build a basic semantic model from
    warehouse : str, optional
        Warehouse name to use for processing suggestions.
    metrics_offset : int, optional
        Pagination offset for metrics suggestions
    metrics_limit : int, optional
        Pagination limit for metrics suggestions
    facts_offset : int, optional
        Pagination offset for facts suggestions
    facts_limit : int, optional
        Pagination limit for facts suggestions
    filters_offset : int, optional
        Pagination offset for filters suggestions
    filters_limit : int, optional
        Pagination limit for filters suggestions
    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    semantic_model: Optional[SemanticModelObject] = None

    tables: Optional[List[TableColumns]] = None

    warehouse: Optional[StrictStr] = None

    metrics_offset: Optional[StrictInt] = None

    metrics_limit: Optional[StrictInt] = None

    facts_offset: Optional[StrictInt] = None

    facts_limit: Optional[StrictInt] = None

    filters_offset: Optional[StrictInt] = None

    filters_limit: Optional[StrictInt] = None

    experimental: Optional[StrictStr] = None

    __properties = [
        "semantic_model",
        "tables",
        "warehouse",
        "metrics_offset",
        "metrics_limit",
        "facts_offset",
        "facts_limit",
        "filters_offset",
        "filters_limit",
        "experimental",
    ]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GenerateFiltersAndMetricsSuggestionsRequest:
        """Create an instance of GenerateFiltersAndMetricsSuggestionsRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of semantic_model
        if self.semantic_model:
            _dict["semantic_model"] = self.semantic_model.to_dict()

        # override the default output from pydantic by calling `to_dict()` of each item in tables (list)
        _items = []
        if self.tables:
            for _item in self.tables:
                if _item:
                    _items.append(_item.to_dict())
            _dict["tables"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateFiltersAndMetricsSuggestionsRequest:
        """Create an instance of GenerateFiltersAndMetricsSuggestionsRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GenerateFiltersAndMetricsSuggestionsRequest.model_validate(obj)

        _obj = GenerateFiltersAndMetricsSuggestionsRequest.model_validate(
            {
                "semantic_model": SemanticModelObject.from_dict(obj.get("semantic_model"))
                if obj.get("semantic_model") is not None
                else None,
                "tables": [TableColumns.from_dict(_item) for _item in obj.get("tables")]
                if obj.get("tables") is not None
                else None,
                "warehouse": obj.get("warehouse"),
                "metrics_offset": obj.get("metrics_offset"),
                "metrics_limit": obj.get("metrics_limit"),
                "facts_offset": obj.get("facts_offset"),
                "facts_limit": obj.get("facts_limit"),
                "filters_offset": obj.get("filters_offset"),
                "filters_limit": obj.get("filters_limit"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class GenerateFiltersAndMetricsSuggestionsRequestModel:
    def __init__(
        self,  # optional properties
        semantic_model: Optional[SemanticModelObject] = None,
        tables: Optional[list[TableColumns]] = None,
        warehouse: Optional[str] = None,
        metrics_offset: Optional[int] = None,
        metrics_limit: Optional[int] = None,
        facts_offset: Optional[int] = None,
        facts_limit: Optional[int] = None,
        filters_offset: Optional[int] = None,
        filters_limit: Optional[int] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the GenerateFiltersAndMetricsSuggestionsRequest resource.

        Constructs an object of type GenerateFiltersAndMetricsSuggestionsRequest with the provided properties.

        Parameters
        __________
        semantic_model : SemanticModelObject, optional

        tables : list[TableColumns], optional
            Tables and selected columns to build a basic semantic model from
        warehouse : str, optional
            Warehouse name to use for processing suggestions.
        metrics_offset : int, optional
            Pagination offset for metrics suggestions
        metrics_limit : int, optional
            Pagination limit for metrics suggestions
        facts_offset : int, optional
            Pagination offset for facts suggestions
        facts_limit : int, optional
            Pagination limit for facts suggestions
        filters_offset : int, optional
            Pagination offset for filters suggestions
        filters_limit : int, optional
            Pagination limit for filters suggestions
        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.semantic_model = semantic_model
        self.tables = tables
        self.warehouse = warehouse
        self.metrics_offset = metrics_offset
        self.metrics_limit = metrics_limit
        self.facts_offset = facts_offset
        self.facts_limit = facts_limit
        self.filters_offset = filters_offset
        self.filters_limit = filters_limit
        self.experimental = experimental

    __properties = [
        "semantic_model",
        "tables",
        "warehouse",
        "metrics_offset",
        "metrics_limit",
        "facts_offset",
        "facts_limit",
        "filters_offset",
        "filters_limit",
        "experimental",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GenerateFiltersAndMetricsSuggestionsRequest(
            semantic_model=self.semantic_model._to_model() if self.semantic_model is not None else None,
            tables=[x._to_model() for x in self.tables] if self.tables is not None else None,
            warehouse=self.warehouse,
            metrics_offset=self.metrics_offset,
            metrics_limit=self.metrics_limit,
            facts_offset=self.facts_offset,
            facts_limit=self.facts_limit,
            filters_offset=self.filters_offset,
            filters_limit=self.filters_limit,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> GenerateFiltersAndMetricsSuggestionsRequestModel:
        return GenerateFiltersAndMetricsSuggestionsRequestModel(
            semantic_model=SemanticModelObjectModel._from_model(model.semantic_model) if model.semantic_model else None,
            tables=[TableColumnsModel._from_model(x) for x in model.tables] if model.tables else None,
            warehouse=model.warehouse,
            metrics_offset=model.metrics_offset,
            metrics_limit=model.metrics_limit,
            facts_offset=model.facts_offset,
            facts_limit=model.facts_limit,
            filters_offset=model.filters_offset,
            filters_limit=model.filters_limit,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GenerateFiltersAndMetricsSuggestionsRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GenerateFiltersAndMetricsSuggestionsRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateFiltersAndMetricsSuggestionsRequestModel:
        """Create an instance of GenerateFiltersAndMetricsSuggestionsRequest from a dict.

        This method constructs a GenerateFiltersAndMetricsSuggestionsRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GenerateFiltersAndMetricsSuggestionsRequest
            A GenerateFiltersAndMetricsSuggestionsRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GenerateFiltersAndMetricsSuggestionsRequest.from_dict(obj))


GenerateFiltersAndMetricsSuggestionsRequest._model_class = GenerateFiltersAndMetricsSuggestionsRequestModel
