"""
Cortex Chat API.

OpenAPI 3.0 specification for the Cortex Chat API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr

from snowflake.core.cortex.chat_service._generated.models.chat_request_messages_inner import (
    ChatRequestMessagesInner,
    ChatRequestMessagesInnerModel,
)
from snowflake.core.cortex.chat_service._generated.models.chat_request_search_services_inner import (
    ChatRequestSearchServicesInner,
    ChatRequestSearchServicesInnerModel,
)
from snowflake.core.cortex.chat_service._generated.models.chat_request_semantic_models_inner import (
    ChatRequestSemanticModelsInner,
    ChatRequestSemanticModelsInnerModel,
)


class ChatRequest(BaseModel):
    """A model object representing the ChatRequest resource.

    Constructs an object of type ChatRequest with the provided properties.

    Parameters
    __________
    query : str
        Unstructured text query.
    model : str, optional
        The model to be used for the chat.
    search_services : list[ChatRequestSearchServicesInner], optional
        List of search services.
    semantic_models : list[ChatRequestSemanticModelsInner], optional
        The semantic models to be used for Cortex Analyst
    prompt : str, optional
        Additional prompt text.
    messages : list[ChatRequestMessagesInner], optional
        List of conversation messages.
    debug : bool, optional
        Whether to return debug information.
    max_results : int, optional
        Global max number of results from search for llm generation. If not set, default to sum of max_results across list of search_service.
    experimental : object, optional
        reserved
    """

    query: StrictStr

    model: Optional[StrictStr] = None

    search_services: Optional[List[ChatRequestSearchServicesInner]] = None

    semantic_models: Optional[List[ChatRequestSemanticModelsInner]] = None

    prompt: Optional[StrictStr] = None

    messages: Optional[List[ChatRequestMessagesInner]] = None

    debug: Optional[StrictBool] = None

    max_results: Optional[StrictInt] = None

    experimental: Optional[Dict[str, Any]] = None

    __properties = [
        "query",
        "model",
        "search_services",
        "semantic_models",
        "prompt",
        "messages",
        "debug",
        "max_results",
        "experimental",
    ]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatRequest:
        """Create an instance of ChatRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in search_services (list)
        _items = []
        if self.search_services:
            for _item in self.search_services:
                if _item:
                    _items.append(_item.to_dict())
            _dict["search_services"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in semantic_models (list)
        _items = []
        if self.semantic_models:
            for _item in self.semantic_models:
                if _item:
                    _items.append(_item.to_dict())
            _dict["semantic_models"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict["messages"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ChatRequest:
        """Create an instance of ChatRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ChatRequest.model_validate(obj)

        _obj = ChatRequest.model_validate(
            {
                "query": obj.get("query"),
                "model": obj.get("model"),
                "search_services": [
                    ChatRequestSearchServicesInner.from_dict(_item) for _item in obj.get("search_services")
                ]
                if obj.get("search_services") is not None
                else None,
                "semantic_models": [
                    ChatRequestSemanticModelsInner.from_dict(_item) for _item in obj.get("semantic_models")
                ]
                if obj.get("semantic_models") is not None
                else None,
                "prompt": obj.get("prompt"),
                "messages": [ChatRequestMessagesInner.from_dict(_item) for _item in obj.get("messages")]
                if obj.get("messages") is not None
                else None,
                "debug": obj.get("debug"),
                "max_results": obj.get("max_results"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class ChatRequestModel:
    def __init__(
        self,
        query: str,
        # optional properties
        model: Optional[str] = None,
        search_services: Optional[list[ChatRequestSearchServicesInner]] = None,
        semantic_models: Optional[list[ChatRequestSemanticModelsInner]] = None,
        prompt: Optional[str] = None,
        messages: Optional[list[ChatRequestMessagesInner]] = None,
        debug: Optional[bool] = None,
        max_results: Optional[int] = None,
        experimental: Optional[object] = None,
    ):
        """A model object representing the ChatRequest resource.

        Constructs an object of type ChatRequest with the provided properties.

        Parameters
        __________
        query : str
            Unstructured text query.
        model : str, optional
            The model to be used for the chat.
        search_services : list[ChatRequestSearchServicesInner], optional
            List of search services.
        semantic_models : list[ChatRequestSemanticModelsInner], optional
            The semantic models to be used for Cortex Analyst
        prompt : str, optional
            Additional prompt text.
        messages : list[ChatRequestMessagesInner], optional
            List of conversation messages.
        debug : bool, optional
            Whether to return debug information.
        max_results : int, optional
            Global max number of results from search for llm generation. If not set, default to sum of max_results across list of search_service.
        experimental : object, optional
            reserved
        """
        self.query = query
        self.model = model
        self.search_services = search_services
        self.semantic_models = semantic_models
        self.prompt = prompt
        self.messages = messages
        self.debug = debug
        self.max_results = max_results
        self.experimental = experimental

    __properties = [
        "query",
        "model",
        "search_services",
        "semantic_models",
        "prompt",
        "messages",
        "debug",
        "max_results",
        "experimental",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ChatRequest(
            query=self.query,
            model=self.model,
            search_services=[x._to_model() for x in self.search_services] if self.search_services is not None else None,
            semantic_models=[x._to_model() for x in self.semantic_models] if self.semantic_models is not None else None,
            prompt=self.prompt,
            messages=[x._to_model() for x in self.messages] if self.messages is not None else None,
            debug=self.debug,
            max_results=self.max_results,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> ChatRequestModel:
        return ChatRequestModel(
            query=model.query,
            model=model.model,
            search_services=[ChatRequestSearchServicesInnerModel._from_model(x) for x in model.search_services]
            if model.search_services
            else None,
            semantic_models=[ChatRequestSemanticModelsInnerModel._from_model(x) for x in model.semantic_models]
            if model.semantic_models
            else None,
            prompt=model.prompt,
            messages=[ChatRequestMessagesInnerModel._from_model(x) for x in model.messages] if model.messages else None,
            debug=model.debug,
            max_results=model.max_results,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ChatRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ChatRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ChatRequestModel:
        """Create an instance of ChatRequest from a dict.

        This method constructs a ChatRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ChatRequest
            A ChatRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ChatRequest.from_dict(obj))


ChatRequest._model_class = ChatRequestModel
