"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator

from snowflake.core.cortex.inference_service._generated.models.non_streaming_complete_response_choices_inner import (
    NonStreamingCompleteResponseChoicesInner,
    NonStreamingCompleteResponseChoicesInnerModel,
)
from snowflake.core.cortex.inference_service._generated.models.usage import Usage, UsageModel


class NonStreamingCompleteResponse(BaseModel):
    """A model object representing the NonStreamingCompleteResponse resource.

    Constructs an object of type NonStreamingCompleteResponse with the provided properties.

    Parameters
    __________
    choices : list[NonStreamingCompleteResponseChoicesInner], optional

    finish_reason : str, optional
        The reason the request was finished.
    usage : Usage, optional
    """

    choices: Optional[List[NonStreamingCompleteResponseChoicesInner]] = None

    finish_reason: Optional[StrictStr] = None

    usage: Optional[Usage] = None

    __properties = ["choices", "finish_reason", "usage"]

    @field_validator("finish_reason")
    def finish_reason_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("stop", "content_filter", "tool_calls", "length"):
            raise ValueError("must validate the enum values ('stop','content_filter','tool_calls','length')")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NonStreamingCompleteResponse:
        """Create an instance of NonStreamingCompleteResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in choices (list)
        _items = []
        if self.choices:
            for _item in self.choices:
                if _item:
                    _items.append(_item.to_dict())
            _dict["choices"] = _items

        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict["usage"] = self.usage.to_dict()

        # set to None if finish_reason (nullable) is None
        if self.finish_reason is None:
            _dict["finish_reason"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NonStreamingCompleteResponse:
        """Create an instance of NonStreamingCompleteResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NonStreamingCompleteResponse.model_validate(obj)

        _obj = NonStreamingCompleteResponse.model_validate(
            {
                "choices": [NonStreamingCompleteResponseChoicesInner.from_dict(_item) for _item in obj.get("choices")]
                if obj.get("choices") is not None
                else None,
                "finish_reason": obj.get("finish_reason"),
                "usage": Usage.from_dict(obj.get("usage")) if obj.get("usage") is not None else None,
            }
        )

        return _obj


class NonStreamingCompleteResponseModel:
    def __init__(
        self,  # optional properties
        choices: Optional[list[NonStreamingCompleteResponseChoicesInner]] = None,
        finish_reason: Optional[str] = None,
        usage: Optional[Usage] = None,
    ):
        """A model object representing the NonStreamingCompleteResponse resource.

        Constructs an object of type NonStreamingCompleteResponse with the provided properties.

        Parameters
        __________
        choices : list[NonStreamingCompleteResponseChoicesInner], optional

        finish_reason : str, optional
            The reason the request was finished.
        usage : Usage, optional
        """
        self.choices = choices
        self.finish_reason = finish_reason
        self.usage = usage

    __properties = ["choices", "finish_reason", "usage"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NonStreamingCompleteResponse(
            choices=[x._to_model() for x in self.choices] if self.choices is not None else None,
            finish_reason=self.finish_reason,
            usage=self.usage._to_model() if self.usage is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> NonStreamingCompleteResponseModel:
        return NonStreamingCompleteResponseModel(
            choices=[NonStreamingCompleteResponseChoicesInnerModel._from_model(x) for x in model.choices]
            if model.choices
            else None,
            finish_reason=model.finish_reason,
            usage=UsageModel._from_model(model.usage) if model.usage else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a NonStreamingCompleteResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NonStreamingCompleteResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NonStreamingCompleteResponseModel:
        """Create an instance of NonStreamingCompleteResponse from a dict.

        This method constructs a NonStreamingCompleteResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NonStreamingCompleteResponse
            A NonStreamingCompleteResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NonStreamingCompleteResponse.from_dict(obj))


NonStreamingCompleteResponse._model_class = NonStreamingCompleteResponseModel
