"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List

from pydantic import BaseModel, ConfigDict, StrictStr


class Message(BaseModel):
    """A model object representing the Message resource.

    Constructs an object of type Message with the provided properties.

    Parameters
    __________
    role : str
        Identifies who sent the message - either the user or the assistant.
        User messages typically contain queries, while assistant messages contain responses and tool results.
    content : list[object]
        Array of content elements making up the message.
        Can include text, tool results, or custom content types.
    """

    role: StrictStr

    content: List[Any]

    __properties = ["role", "content"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Message:
        """Create an instance of Message from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Message:
        """Create an instance of Message from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Message.model_validate(obj)

        _obj = Message.model_validate(
            {
                "role": obj.get("role"),
                "content": obj.get("content"),
            }
        )

        return _obj


class MessageModel:
    def __init__(
        self,
        role: str,
        content: list[object],
        # optional properties
    ):
        """A model object representing the Message resource.

                Constructs an object of type Message with the provided properties.

                Parameters
                __________
                role : str
                    Identifies who sent the message - either the user or the assistant.
        User messages typically contain queries, while assistant messages contain responses and tool results.

                content : list[object]
                    Array of content elements making up the message.
        Can include text, tool results, or custom content types.
        """
        self.role = role
        self.content = content

    __properties = ["role", "content"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Message(
            role=self.role,
            content=self.content,
        )

    @classmethod
    def _from_model(cls, model) -> MessageModel:
        return MessageModel(
            role=model.role,
            content=model.content,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Message.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Message object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageModel:
        """Create an instance of Message from a dict.

        This method constructs a Message object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Message
            A Message object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Message.from_dict(obj))


Message._model_class = MessageModel
