"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.lite_agent_service._generated.models.tool_tool_spec_input_schema import (
    ToolToolSpecInputSchema,
)


class ToolToolSpec(BaseModel):
    """A model object representing the ToolToolSpec resource.

    Constructs an object of type ToolToolSpec with the provided properties.

    Parameters
    __________
    type : str
        The type of tool capability. Can be specialized types like
        'cortex_analyst_text_to_sql' or 'generic' for general-purpose tools.
    name : str
        Unique identifier for referencing this tool instance.
        Used to match with configuration in tool_resources.
    description : str, optional
        Description of the tool to be considered for tool use
    input_schema : ToolToolSpecInputSchema, optional
    """

    type: StrictStr

    name: StrictStr

    description: Optional[StrictStr] = None

    input_schema: Optional[ToolToolSpecInputSchema] = None

    __properties = ["type", "name", "description", "input_schema"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ToolToolSpec:
        """Create an instance of ToolToolSpec from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of input_schema
        if self.input_schema:
            _dict["input_schema"] = self.input_schema.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ToolToolSpec:
        """Create an instance of ToolToolSpec from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ToolToolSpec.model_validate(obj)

        _obj = ToolToolSpec.model_validate(
            {
                "type": obj.get("type"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "input_schema": ToolToolSpecInputSchema.from_dict(obj.get("input_schema"))
                if obj.get("input_schema") is not None
                else None,
            }
        )

        return _obj


class ToolToolSpecModel:
    def __init__(
        self,
        type: str,
        name: str,
        # optional properties
        description: Optional[str] = None,
        input_schema: Optional[ToolToolSpecInputSchema] = None,
    ):
        """A model object representing the ToolToolSpec resource.

                Constructs an object of type ToolToolSpec with the provided properties.

                Parameters
                __________
                type : str
                    The type of tool capability. Can be specialized types like
        'cortex_analyst_text_to_sql' or 'generic' for general-purpose tools.

                name : str
                    Unique identifier for referencing this tool instance.
        Used to match with configuration in tool_resources.

                description : str, optional
                    Description of the tool to be considered for tool use
                input_schema : ToolToolSpecInputSchema, optional
        """
        self.type = type
        self.name = name
        self.description = description
        self.input_schema = input_schema

    __properties = ["type", "name", "description", "input_schema"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ToolToolSpec(
            type=self.type,
            name=self.name,
            description=self.description,
            input_schema=self.input_schema,
        )

    @classmethod
    def _from_model(cls, model) -> ToolToolSpecModel:
        return ToolToolSpecModel(
            type=model.type,
            name=model.name,
            description=model.description,
            input_schema=model.input_schema,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ToolToolSpec.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ToolToolSpec object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ToolToolSpecModel:
        """Create an instance of ToolToolSpec from a dict.

        This method constructs a ToolToolSpec object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ToolToolSpec
            A ToolToolSpec object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ToolToolSpec.from_dict(obj))


ToolToolSpec._model_class = ToolToolSpecModel
