"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.search_service._generated.models.suggest_result import SuggestResult, SuggestResultModel


class SuggestQueryResponse(BaseModel):
    """A model object representing the SuggestQueryResponse resource.

    Constructs an object of type SuggestQueryResponse with the provided properties.

    Parameters
    __________
    results : list[SuggestResult]
        List of result rows.
    request_id : str
        ID of the request.
    """

    results: List[SuggestResult]

    request_id: StrictStr

    __properties = ["results", "request_id"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SuggestQueryResponse:
        """Create an instance of SuggestQueryResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item in self.results:
                if _item:
                    _items.append(_item.to_dict())
            _dict["results"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SuggestQueryResponse:
        """Create an instance of SuggestQueryResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SuggestQueryResponse.model_validate(obj)

        _obj = SuggestQueryResponse.model_validate(
            {
                "results": [SuggestResult.from_dict(_item) for _item in obj.get("results")]
                if obj.get("results") is not None
                else None,
                "request_id": obj.get("request_id"),
            }
        )

        return _obj


class SuggestQueryResponseModel:
    def __init__(
        self,
        results: list[SuggestResult],
        request_id: str,
        # optional properties
    ):
        """A model object representing the SuggestQueryResponse resource.

        Constructs an object of type SuggestQueryResponse with the provided properties.

        Parameters
        __________
        results : list[SuggestResult]
            List of result rows.
        request_id : str
            ID of the request.
        """
        self.results = results
        self.request_id = request_id

    __properties = ["results", "request_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SuggestQueryResponse(
            results=[x._to_model() for x in self.results] if self.results is not None else None,
            request_id=self.request_id,
        )

    @classmethod
    def _from_model(cls, model) -> SuggestQueryResponseModel:
        return SuggestQueryResponseModel(
            results=[SuggestResultModel._from_model(x) for x in model.results] if model.results else None,
            request_id=model.request_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SuggestQueryResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SuggestQueryResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SuggestQueryResponseModel:
        """Create an instance of SuggestQueryResponse from a dict.

        This method constructs a SuggestQueryResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SuggestQueryResponse
            A SuggestQueryResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SuggestQueryResponse.from_dict(obj))


SuggestQueryResponse._model_class = SuggestQueryResponseModel
