"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional, Union

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt


class Weights(BaseModel):
    """A model object representing the Weights resource.

    Constructs an object of type Weights with the provided properties.

    Parameters
    __________
    texts : float, optional
        Weight to apply to all text-specific columns.
    vectors : float, optional
        Weight to apply to all vector-specific columns.
    reranker : float, optional
        Weight to apply to reranker-specific scoring component.
    """

    texts: Optional[Union[StrictFloat, StrictInt]] = None

    vectors: Optional[Union[StrictFloat, StrictInt]] = None

    reranker: Optional[Union[StrictFloat, StrictInt]] = None

    __properties = ["texts", "vectors", "reranker"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Weights:
        """Create an instance of Weights from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Weights:
        """Create an instance of Weights from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Weights.model_validate(obj)

        _obj = Weights.model_validate(
            {
                "texts": obj.get("texts"),
                "vectors": obj.get("vectors"),
                "reranker": obj.get("reranker"),
            }
        )

        return _obj


class WeightsModel:
    def __init__(
        self,  # optional properties
        texts: Optional[float] = None,
        vectors: Optional[float] = None,
        reranker: Optional[float] = None,
    ):
        """A model object representing the Weights resource.

        Constructs an object of type Weights with the provided properties.

        Parameters
        __________
        texts : float, optional
            Weight to apply to all text-specific columns.
        vectors : float, optional
            Weight to apply to all vector-specific columns.
        reranker : float, optional
            Weight to apply to reranker-specific scoring component.
        """
        self.texts = texts
        self.vectors = vectors
        self.reranker = reranker

    __properties = ["texts", "vectors", "reranker"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Weights(
            texts=self.texts,
            vectors=self.vectors,
            reranker=self.reranker,
        )

    @classmethod
    def _from_model(cls, model) -> WeightsModel:
        return WeightsModel(
            texts=model.texts,
            vectors=model.vectors,
            reranker=model.reranker,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Weights.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Weights object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> WeightsModel:
        """Create an instance of Weights from a dict.

        This method constructs a Weights object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Weights
            A Weights object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Weights.from_dict(obj))


Weights._model_class = WeightsModel
