"""
Snowflake Database API.

The Snowflake Database API is a REST API that you can use to access, update, and perform certain actions on Database resource in Snowflake.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import json
import logging
import os
import re
import tempfile

from concurrent.futures import Future
from datetime import date, datetime
from typing import Iterable, List, Literal, Optional, Union, overload

from dateutil.parser import parse
from pydantic import Field, StrictBool, StrictStr, validate_call
from typing_extensions import Annotated

import snowflake.core._http_requests

from snowflake.core._generated import rest
from snowflake.core._generated.api_client import ApiClient
from snowflake.core._internal.utils import is_running_inside_stored_procedure
from snowflake.core.database._generated import models
from snowflake.core.database._generated.models.account_identifiers import AccountIdentifiers
from snowflake.core.database._generated.models.database import Database
from snowflake.core.database._generated.models.database_clone import DatabaseClone
from snowflake.core.database._generated.models.database_from_share import DatabaseFromShare
from snowflake.core.database._generated.models.success_response import SuccessResponse
from snowflake.core.database._generated.models.tag_assignment import TagAssignment
from snowflake.core.database._generated.models.tag_reference import TagReference
from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError,
    _APIValueError,
)


logger = logging.getLogger(__name__)


class DatabaseApi:
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = "database"
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default()

    @property
    def api_client(self):
        return self._api_client

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if isinstance(klass, str):
            if klass.startswith("Iterable["):
                sub_kls = re.match(r"Iterable\[(.*)]", klass).group(1)
                return [self.__deserialize(sub_data, sub_kls) for sub_data in data]

            if klass.startswith("Dict["):
                sub_kls = re.match(r"Dict\[([^,]*), (.*)]", klass).group(2)
                return {k: self.__deserialize(v, sub_kls) for k, v in data.items()}

            # convert str to class
            if klass in snowflake.core._http_requests.NATIVE_TYPES_MAPPING:
                klass = snowflake.core._http_requests.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in snowflake.core._http_requests.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:  # noqa: E721
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def __deserialize_file(self, response):
        """Deserializes body to file.

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.api_client.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=f"Failed to parse `{string}` as date object")

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=(f"Failed to parse `{string}` as datetime object"))

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        return klass.from_dict(data)

    @overload
    def create_database(
        self,
        database: Database,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_database(
        self,
        database: Database,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_database(
        self,
        database: Database,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_database(
        self,
        database: Database,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a database.  # noqa: E501

        Creates a database, with modifiers as query parameters. You must provide the full database definition when creating a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_database(database, create_mode, kind, async_req=True)
        >>> result = future.result()
        :param database: (required)
        :type database: Database
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_database_with_http_info(database, create_mode, kind, **kwargs)

    @validate_call
    def create_database_with_http_info(
        self,
        database: Database,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Create a database.  # noqa: E501

        Creates a database, with modifiers as query parameters. You must provide the full database definition when creating a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_database_with_http_info(database, create_mode, kind, async_req=True)
        >>> result = future.result()
        :param database: (required)
        :type database: Database
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "create_mode", "kind"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_database")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("kind") is not None:
            _query_params.append(("kind", _params["kind"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["database"] is not None:
            _body_params = _params["database"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_database_from_share(
        self,
        database_from_share: DatabaseFromShare,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_database_from_share(
        self,
        database_from_share: DatabaseFromShare,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_database_from_share(
        self,
        database_from_share: DatabaseFromShare,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_database_from_share(
        self,
        database_from_share: DatabaseFromShare,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a database from a share.  # noqa: E501

        Creates a database from a given share.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_database_from_share(database_from_share, create_mode, share, async_req=True)
        >>> result = future.result()
        :param database_from_share: (required)
        :type database_from_share: DatabaseFromShare
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param share: ID of the share from which to create the database, in the form \"<provider_account>.<share_name>\".
        :type share: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_database_from_share_with_http_info(database_from_share, create_mode, share, **kwargs)

    @validate_call
    def create_database_from_share_with_http_info(
        self,
        database_from_share: DatabaseFromShare,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        **kwargs,
    ):
        r"""Create a database from a share.  # noqa: E501

        Creates a database from a given share.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_database_from_share_with_http_info(
        ...     database_from_share, create_mode, share, async_req=True
        ... )
        >>> result = future.result()
        :param database_from_share: (required)
        :type database_from_share: DatabaseFromShare
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param share: ID of the share from which to create the database, in the form \"<provider_account>.<share_name>\".
        :type share: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database_from_share", "create_mode", "share"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_database_from_share")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("share") is not None:
            _query_params.append(("share", _params["share"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["database_from_share"] is not None:
            _body_params = _params["database_from_share"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases:from-share",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_database_from_share_deprecated(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_database_from_share_deprecated(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_database_from_share_deprecated(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_database_from_share_deprecated(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a database from a share.  # noqa: E501

        Creates a database from a given share.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_database_from_share_deprecated(name, create_mode, share, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param share: ID of the share from which to create the database, in the form \"<provider_account>.<share_name>\".
        :type share: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_database_from_share_deprecated_with_http_info(name, create_mode, share, **kwargs)

    @validate_call
    def create_database_from_share_deprecated_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        share: Annotated[
            Optional[StrictStr],
            Field(
                description='ID of the share from which to create the database, in the form "<provider_account>.<share_name>".'
            ),
        ] = None,
        **kwargs,
    ):
        r"""Create a database from a share.  # noqa: E501

        Creates a database from a given share.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_database_from_share_deprecated_with_http_info(
        ...     name, create_mode, share, async_req=True
        ... )
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param share: ID of the share from which to create the database, in the form \"<provider_account>.<share_name>\".
        :type share: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "create_mode", "share"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method create_database_from_share_deprecated"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("share") is not None:
            _query_params.append(("share", _params["share"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}:from_share",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def create_or_alter_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database: Database,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_or_alter_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database: Database,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_or_alter_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database: Database,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_or_alter_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database: Database,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a new, or alters an existing, database.  # noqa: E501

        Creates a new, or alters an existing, database. You must provide the full database definition even when altering an existing database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_database(name, database, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param database: (required)
        :type database: Database
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_or_alter_database_with_http_info(name, database, **kwargs)

    @validate_call
    def create_or_alter_database_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database: Database,
        **kwargs,
    ):
        r"""Create a new, or alters an existing, database.  # noqa: E501

        Creates a new, or alters an existing, database. You must provide the full database definition even when altering an existing database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_database_with_http_info(name, database, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param database: (required)
        :type database: Database
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "database"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_or_alter_database")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["database"] is not None:
            _body_params = _params["database"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def clone_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database_clone: DatabaseClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def clone_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database_clone: DatabaseClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def clone_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database_clone: DatabaseClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def clone_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database_clone: DatabaseClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Clone a database.  # noqa: E501

        Clones an existing database, with modifiers as query parameters. You must provide the full database definition when cloning an existing database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.clone_database(name, database_clone, create_mode, kind, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param database_clone: (required)
        :type database_clone: DatabaseClone
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.clone_database_with_http_info(name, database_clone, create_mode, kind, **kwargs)

    @validate_call
    def clone_database_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        database_clone: DatabaseClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description="Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Clone a database.  # noqa: E501

        Clones an existing database, with modifiers as query parameters. You must provide the full database definition when cloning an existing database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.clone_database_with_http_info(name, database_clone, create_mode, kind, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param database_clone: (required)
        :type database_clone: DatabaseClone
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of database to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "database_clone", "create_mode", "kind"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method clone_database")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("kind") is not None:
            _query_params.append(("kind", _params["kind"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["database_clone"] is not None:
            _body_params = _params["database_clone"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}:clone",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def disable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def disable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def disable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def disable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Disable database failover.  # noqa: E501

        Disables failover for this primary database, meaning no replica of this database (i.e. secondary database) can be promoted to serve as the primary database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.disable_database_failover(name, account_identifiers, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers:
        :type account_identifiers: AccountIdentifiers
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.disable_database_failover_with_http_info(name, account_identifiers, **kwargs)

    @validate_call
    def disable_database_failover_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        **kwargs,
    ):
        r"""Disable database failover.  # noqa: E501

        Disables failover for this primary database, meaning no replica of this database (i.e. secondary database) can be promoted to serve as the primary database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.disable_database_failover_with_http_info(name, account_identifiers, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers:
        :type account_identifiers: AccountIdentifiers
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "account_identifiers"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method disable_database_failover")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["account_identifiers"] is not None:
            _body_params = _params["account_identifiers"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}/failover:disable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def disable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def disable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def disable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def disable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Disable database replication.  # noqa: E501

        Disables replication for this primary database, meaning no replica of this database (i.e. secondary database) in another account can be refreshed. Any secondary databases remain linked to the primary database, but requests to refresh a secondary database are denied.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.disable_database_replication(name, account_identifiers, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers:
        :type account_identifiers: AccountIdentifiers
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.disable_database_replication_with_http_info(name, account_identifiers, **kwargs)

    @validate_call
    def disable_database_replication_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: Optional[AccountIdentifiers] = None,
        **kwargs,
    ):
        r"""Disable database replication.  # noqa: E501

        Disables replication for this primary database, meaning no replica of this database (i.e. secondary database) in another account can be refreshed. Any secondary databases remain linked to the primary database, but requests to refresh a secondary database are denied.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.disable_database_replication_with_http_info(name, account_identifiers, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers:
        :type account_identifiers: AccountIdentifiers
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "account_identifiers"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method disable_database_replication"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["account_identifiers"] is not None:
            _body_params = _params["account_identifiers"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}/replication:disable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def enable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def enable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def enable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def enable_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Enable database failover.  # noqa: E501

        Specifies a comma-separated list of accounts in your organization where a replica of this primary database can be promoted to serve as the primary database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.enable_database_failover(name, account_identifiers, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers: (required)
        :type account_identifiers: AccountIdentifiers
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.enable_database_failover_with_http_info(name, account_identifiers, **kwargs)

    @validate_call
    def enable_database_failover_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        **kwargs,
    ):
        r"""Enable database failover.  # noqa: E501

        Specifies a comma-separated list of accounts in your organization where a replica of this primary database can be promoted to serve as the primary database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.enable_database_failover_with_http_info(name, account_identifiers, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers: (required)
        :type account_identifiers: AccountIdentifiers
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "account_identifiers"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method enable_database_failover")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["account_identifiers"] is not None:
            _body_params = _params["account_identifiers"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}/failover:enable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def enable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        ignore_edition_check: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def enable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        ignore_edition_check: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def enable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        ignore_edition_check: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def enable_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        ignore_edition_check: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Enable database replication.  # noqa: E501

        Promotes a local database to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.enable_database_replication(
        ...     name, account_identifiers, ignore_edition_check, async_req=True
        ... )
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers: (required)
        :type account_identifiers: AccountIdentifiers
        :param ignore_edition_check: Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference.
        :type ignore_edition_check: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.enable_database_replication_with_http_info(
            name, account_identifiers, ignore_edition_check, **kwargs
        )

    @validate_call
    def enable_database_replication_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        account_identifiers: AccountIdentifiers,
        ignore_edition_check: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Enable database replication.  # noqa: E501

        Promotes a local database to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.enable_database_replication_with_http_info(
        ...     name, account_identifiers, ignore_edition_check, async_req=True
        ... )
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param account_identifiers: (required)
        :type account_identifiers: AccountIdentifiers
        :param ignore_edition_check: Whether to allow replicating data to accounts on lower editions. Default: `true`. For more information, see the <a href=https://docs.snowflake.com/en/sql-reference/sql/alter-database> ALTER DATABASE</a> reference.
        :type ignore_edition_check: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "account_identifiers", "ignore_edition_check"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method enable_database_replication"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("ignore_edition_check") is not None:
            _query_params.append(("ignore_edition_check", _params["ignore_edition_check"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["account_identifiers"] is not None:
            _body_params = _params["account_identifiers"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}/replication:enable",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def fetch_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Database: ...

    @overload
    def fetch_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Database]: ...

    @overload
    def fetch_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[Database, Future[Database]]: ...

    @validate_call
    def fetch_database(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ) -> Union[Database, Future[Database]]:
        r"""fetch_database  # noqa: E501

        Fetches a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_database(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Database, Future[Database]]
        """
        kwargs["_return_http_data_only"] = True
        return self.fetch_database_with_http_info(name, **kwargs)

    @validate_call
    def fetch_database_with_http_info(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ):
        r"""fetch_database  # noqa: E501

        Fetches a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_database_with_http_info(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Database, Future[Database]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method fetch_database")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Database",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[TagAssignment]: ...

    @overload
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[TagAssignment]]: ...

    @overload
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]: ...

    @validate_call
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]:
        r"""Get the tag assignments for a database.  # noqa: E501

        Returns all tags assigned to a database. This operation requires an active warehouse.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_tags(name, with_lineage, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param with_lineage: Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        :type with_lineage: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.get_tags_with_http_info(name, with_lineage, **kwargs)

    @validate_call
    def get_tags_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Get the tag assignments for a database.  # noqa: E501

        Returns all tags assigned to a database. This operation requires an active warehouse.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_tags_with_http_info(name, with_lineage, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param with_lineage: Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        :type with_lineage: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "with_lineage"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method get_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("with_lineage") is not None:
            _query_params.append(("withLineage", _params["with_lineage"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[TagAssignment]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}:get-tags",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_databases(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(description="Optionally includes dropped databases that have not yet been purged."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[Database]: ...

    @overload
    def list_databases(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(description="Optionally includes dropped databases that have not yet been purged."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[Database]]: ...

    @overload
    def list_databases(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(description="Optionally includes dropped databases that have not yet been purged."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[Database], Future[Iterable[Database]]]: ...

    @validate_call
    def list_databases(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(description="Optionally includes dropped databases that have not yet been purged."),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[Database], Future[Iterable[Database]]]:
        r"""List databases.  # noqa: E501

        Lists the accessible databases.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_databases(like, starts_with, show_limit, from_name, history, async_req=True)
        >>> result = future.result()
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param history: Optionally includes dropped databases that have not yet been purged.
        :type history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Database], Future[Iterable[Database]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_databases_with_http_info(like, starts_with, show_limit, from_name, history, **kwargs)

    @validate_call
    def list_databases_with_http_info(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(description="Optionally includes dropped databases that have not yet been purged."),
        ] = None,
        **kwargs,
    ):
        r"""List databases.  # noqa: E501

        Lists the accessible databases.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_databases_with_http_info(
        ...     like, starts_with, show_limit, from_name, history, async_req=True
        ... )
        >>> result = future.result()
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param history: Optionally includes dropped databases that have not yet been purged.
        :type history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Database], Future[Iterable[Database]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["like", "starts_with", "show_limit", "from_name", "history"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_databases")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get("like") is not None:
            _query_params.append(("like", _params["like"]))

        if _params.get("starts_with") is not None:
            _query_params.append(("startsWith", _params["starts_with"]))

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        if _params.get("from_name") is not None:
            _query_params.append(("fromName", _params["from_name"]))

        if _params.get("history") is not None:
            _query_params.append(("history", _params["history"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[Database]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def primary_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def primary_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def primary_database_failover(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def primary_database_failover(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Set a primary database.  # noqa: E501

        Promotes the specified secondary (replica) database to serve as the primary database. When promoted, the database becomes writeable. At the same time, the previous primary database becomes a read-only secondary database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.primary_database_failover(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.primary_database_failover_with_http_info(name, **kwargs)

    @validate_call
    def primary_database_failover_with_http_info(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ):
        r"""Set a primary database.  # noqa: E501

        Promotes the specified secondary (replica) database to serve as the primary database. When promoted, the database becomes writeable. At the same time, the previous primary database becomes a read-only secondary database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.primary_database_failover_with_http_info(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method primary_database_failover")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}/failover:primary",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def refresh_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def refresh_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def refresh_database_replication(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def refresh_database_replication(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Refresh database replications.  # noqa: E501

        Refreshes a secondary database from a snapshot of its primary database. A snapshot includes changes to the objects and data. If you call this endpoint while another refresh for the same replica database is running, it fails and returns an error. Snowflake ensures only one refresh is executed at any given time.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.refresh_database_replication(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.refresh_database_replication_with_http_info(name, **kwargs)

    @validate_call
    def refresh_database_replication_with_http_info(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ):
        r"""Refresh database replications.  # noqa: E501

        Refreshes a secondary database from a snapshot of its primary database. A snapshot includes changes to the objects and data. If you call this endpoint while another refresh for the same replica database is running, it fails and returns an error. Snowflake ensures only one refresh is executed at any given time.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.refresh_database_replication_with_http_info(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method refresh_database_replication"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}/replication:refresh",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Set tags on a database.  # noqa: E501

        Set tags on a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_tags(name, tag_assignment, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_assignment: (required)
        :type tag_assignment: List[TagAssignment]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.set_tags_with_http_info(name, tag_assignment, if_exists, **kwargs)

    @validate_call
    def set_tags_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Set tags on a database.  # noqa: E501

        Set tags on a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_tags_with_http_info(name, tag_assignment, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_assignment: (required)
        :type tag_assignment: List[TagAssignment]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "tag_assignment", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method set_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["tag_assignment"] is not None:
            _body_params = _params["tag_assignment"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}:set-tags",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def undrop_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def undrop_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def undrop_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def undrop_database(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Undrop a database.  # noqa: E501

        Undrops database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.undrop_database(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.undrop_database_with_http_info(name, **kwargs)

    @validate_call
    def undrop_database_with_http_info(
        self, name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")], **kwargs
    ):
        r"""Undrop a database.  # noqa: E501

        Undrops database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.undrop_database_with_http_info(name, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method undrop_database")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}:undrop",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Unset tags from a database.  # noqa: E501

        Unset tags from a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.unset_tags(name, tag_reference, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_reference: (required)
        :type tag_reference: List[TagReference]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.unset_tags_with_http_info(name, tag_reference, if_exists, **kwargs)

    @validate_call
    def unset_tags_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Unset tags from a database.  # noqa: E501

        Unset tags from a database.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.unset_tags_with_http_info(name, tag_reference, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_reference: (required)
        :type tag_reference: List[TagReference]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "tag_reference", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method unset_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["tag_reference"] is not None:
            _body_params = _params["tag_reference"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}:unset-tags",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def delete_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        restrict: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def delete_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        restrict: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def delete_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        restrict: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def delete_database(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        restrict: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Delete a database.  # noqa: E501

        Deletes the specified database. If you enable the `ifExists` parameter, the operation succeeds even if the database does not exist. Otherwise, a 404 failure is returned if the database does not exist. if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_database(name, if_exists, restrict, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param restrict: Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables.
        :type restrict: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_database_with_http_info(name, if_exists, restrict, **kwargs)

    @validate_call
    def delete_database_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        restrict: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Delete a database.  # noqa: E501

        Deletes the specified database. If you enable the `ifExists` parameter, the operation succeeds even if the database does not exist. Otherwise, a 404 failure is returned if the database does not exist. if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_database_with_http_info(name, if_exists, restrict, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param restrict: Whether to drop the database if foreign keys exist that reference any tables in the database. - `true`: Return a warning about existing foreign key references and don't drop the database. - `false`: Drop the database and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables.
        :type restrict: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "if_exists", "restrict"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method delete_database")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        if _params.get("restrict") is not None:
            _query_params.append(("restrict", _params["restrict"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )
