"""
Snowflake External Volume API.

The Snowflake External Volume API is a REST API that you can use to access, update, and perform certain actions on External Volume resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, ClassVar, Dict, Optional, Union

from pydantic import BaseModel, ConfigDict, StrictStr

import snowflake.core.external_volume._generated.models

from snowflake.core.external_volume._generated.models import *  # noqa: F403


class StorageLocation(BaseModel):
    """A model object representing the StorageLocation resource.

    Constructs an object of type StorageLocation with the provided properties.

    Parameters
    __________
    name : str
    """

    name: StrictStr

    __properties = ["name", "storage_provider"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "storage_provider"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "AZURE": "StorageLocationAzure",
        "GCS": "StorageLocationGcs",
        "S3": "StorageLocationS3",
        "S3GOV": "StorageLocationS3Gov",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        "StorageLocationAzure": "AZURE",
        "StorageLocationGcs": "GCS",
        "StorageLocationS3": "S3",
        "StorageLocationS3Gov": "S3GOV",
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[StorageLocationAzure, StorageLocationGcs, StorageLocationS3, StorageLocationS3Gov]:
        """Create an instance of StorageLocation from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[StorageLocationAzure, StorageLocationGcs, StorageLocationS3, StorageLocationS3Gov]:
        """Create an instance of StorageLocation from a dict."""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(snowflake.core.external_volume._generated.models, object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "StorageLocation failed to lookup discriminator value from "
                + json.dumps(obj)
                + ". Discriminator property name: "
                + cls.__discriminator_property_name
                + ", mapping: "
                + json.dumps(cls.__discriminator_value_class_map)
            )


class StorageLocationModel:
    def __init__(
        self,
        name: str,
        # optional properties
    ):
        """A model object representing the StorageLocation resource.

        Constructs an object of type StorageLocation with the provided properties.

        Parameters
        __________
        name : str
        """
        self.name = name

    __properties = ["name", "storage_provider"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StorageLocation(
            name=self.name,
        )

    @classmethod
    def _from_model(cls, model) -> StorageLocationModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Create a dictionary of the properties from a StorageLocation.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StorageLocation object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[StorageLocationAzureModel, StorageLocationGcsModel, StorageLocationS3Model, StorageLocationS3GovModel]:
        """Create an instance of StorageLocation from a dict.

        This method constructs a StorageLocation object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StorageLocation
            A StorageLocation object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StorageLocation.from_dict(obj))


StorageLocation._model_class = StorageLocationModel
