"""
Snowflake External Volume API.

The Snowflake External Volume API is a REST API that you can use to access, update, and perform certain actions on External Volume resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.external_volume._generated.models.encryption import Encryption, EncryptionModel
from snowflake.core.external_volume._generated.models.storage_location import StorageLocation


class StorageLocationGcs(StorageLocation):
    """A model object representing the StorageLocationGcs resource.

    Constructs an object of type StorageLocationGcs with the provided properties.

    Parameters
    __________

    name : str

    storage_base_url : str
        Specifies the base URL for your cloud storage location.
    encryption : Encryption, optional
    """

    storage_base_url: StrictStr

    encryption: Optional[Encryption] = None

    __properties = ["name", "storage_provider"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StorageLocationGcs:
        """Create an instance of StorageLocationGcs from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of encryption
        if self.encryption:
            _dict["encryption"] = self.encryption.to_dict()

        _dict["storage_provider"] = StorageLocation.get_child_model_discriminator_value("StorageLocationGcs")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StorageLocationGcs:
        """Create an instance of StorageLocationGcs from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StorageLocationGcs.model_validate(obj)

        _obj = StorageLocationGcs.model_validate(
            {
                "name": obj.get("name"),
                "storage_base_url": obj.get("storage_base_url"),
                "encryption": Encryption.from_dict(obj.get("encryption"))
                if obj.get("encryption") is not None
                else None,
            }
        )

        return _obj


class StorageLocationGcsModel(StorageLocation):
    def __init__(
        self,
        name: str,
        storage_base_url: str,
        # optional properties
        encryption: Optional[Encryption] = None,
    ):
        """A model object representing the StorageLocationGcs resource.

        Constructs an object of type StorageLocationGcs with the provided properties.

        Parameters
        __________

        name : str

        storage_base_url : str
            Specifies the base URL for your cloud storage location.
        encryption : Encryption, optional
        """
        super().__init__(
            name=name,
        )
        self.storage_base_url = storage_base_url
        self.encryption = encryption

    __properties = ["name", "storage_provider"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StorageLocationGcs(
            name=self.name,
            storage_base_url=self.storage_base_url,
            encryption=self.encryption._to_model() if self.encryption is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> StorageLocationGcsModel:
        return StorageLocationGcsModel(
            name=model.name,
            storage_base_url=model.storage_base_url,
            encryption=EncryptionModel._from_model(model.encryption) if model.encryption else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StorageLocationGcs.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StorageLocationGcs object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StorageLocationGcsModel:
        """Create an instance of StorageLocationGcs from a dict.

        This method constructs a StorageLocationGcs object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StorageLocationGcs
            A StorageLocationGcs object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StorageLocationGcs.from_dict(obj))


StorageLocationGcs._model_class = StorageLocationGcsModel
