"""
Snowflake Grant API.

The Snowflake Grant API is a REST API that you can use to show or manage privileges that have been provided to users and roles in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import json
import logging
import os
import re
import tempfile

from concurrent.futures import Future
from datetime import date, datetime
from typing import Iterable, Literal, Optional, Union, overload

from dateutil.parser import parse
from pydantic import Field, StrictStr, validate_call
from typing_extensions import Annotated

import snowflake.core._http_requests

from snowflake.core._generated import rest
from snowflake.core._generated.api_client import ApiClient
from snowflake.core._internal.utils import is_running_inside_stored_procedure
from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError,
    _APIValueError,
)
from snowflake.core.grant._generated import models
from snowflake.core.grant._generated.models.grant import Grant
from snowflake.core.grant._generated.models.success_response import SuccessResponse


logger = logging.getLogger(__name__)


class GrantApi:
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = "grant"
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default()

    @property
    def api_client(self):
        return self._api_client

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if isinstance(klass, str):
            if klass.startswith("Iterable["):
                sub_kls = re.match(r"Iterable\[(.*)]", klass).group(1)
                return [self.__deserialize(sub_data, sub_kls) for sub_data in data]

            if klass.startswith("Dict["):
                sub_kls = re.match(r"Dict\[([^,]*), (.*)]", klass).group(2)
                return {k: self.__deserialize(v, sub_kls) for k, v in data.items()}

            # convert str to class
            if klass in snowflake.core._http_requests.NATIVE_TYPES_MAPPING:
                klass = snowflake.core._http_requests.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in snowflake.core._http_requests.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:  # noqa: E721
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def __deserialize_file(self, response):
        """Deserializes body to file.

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.api_client.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=f"Failed to parse `{string}` as date object")

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=(f"Failed to parse `{string}` as datetime object"))

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        return klass.from_dict(data)

    @overload
    def grant_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        grant: Grant,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def grant_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        grant: Grant,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def grant_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        grant: Grant,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def grant_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        grant: Grant,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Grant the specified privilege(s) on all/future (as specified by bulkGrantType) securables of this type in a given scope to the named grantee.  # noqa: E501

        Endpoint to indicate that the privileges listed in the request body should be granted to all securables of this type in the given scope.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_group_privilege(
        ...     grantee_type,
        ...     grantee_name,
        ...     bulk_grant_type,
        ...     securable_type_plural,
        ...     scope_type,
        ...     scope_name,
        ...     grant,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param bulk_grant_type: String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type (required)
        :type bulk_grant_type: str
        :param securable_type_plural: String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either \"schemas\" or any plural object type that can nest under a schema such as \"tables\" (required)
        :type securable_type_plural: str
        :param scope_type: String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA (required)
        :type scope_type: str
        :param scope_name: String that specifies the name of resource that is the scope of an ALL/FUTURE privilege (required)
        :type scope_name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.grant_group_privilege_with_http_info(
            grantee_type, grantee_name, bulk_grant_type, securable_type_plural, scope_type, scope_name, grant, **kwargs
        )

    @validate_call
    def grant_group_privilege_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        grant: Grant,
        **kwargs,
    ):
        r"""Grant the specified privilege(s) on all/future (as specified by bulkGrantType) securables of this type in a given scope to the named grantee.  # noqa: E501

        Endpoint to indicate that the privileges listed in the request body should be granted to all securables of this type in the given scope.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_group_privilege_with_http_info(
        ...     grantee_type,
        ...     grantee_name,
        ...     bulk_grant_type,
        ...     securable_type_plural,
        ...     scope_type,
        ...     scope_name,
        ...     grant,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param bulk_grant_type: String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type (required)
        :type bulk_grant_type: str
        :param securable_type_plural: String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either \"schemas\" or any plural object type that can nest under a schema such as \"tables\" (required)
        :type securable_type_plural: str
        :param scope_type: String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA (required)
        :type scope_type: str
        :param scope_name: String that specifies the name of resource that is the scope of an ALL/FUTURE privilege (required)
        :type scope_name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = [
            "grantee_type",
            "grantee_name",
            "bulk_grant_type",
            "securable_type_plural",
            "scope_type",
            "scope_name",
            "grant",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method grant_group_privilege")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        if _params["bulk_grant_type"]:
            _path_params["bulkGrantType"] = _params["bulk_grant_type"]

        if _params["securable_type_plural"]:
            _path_params["securableTypePlural"] = _params["securable_type_plural"]

        if _params["scope_type"]:
            _path_params["scopeType"] = _params["scope_type"]

        if _params["scope_name"]:
            _path_params["scopeName"] = _params["scope_name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["grant"] is not None:
            _body_params = _params["grant"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}/{bulkGrantType}/{securableTypePlural}/{scopeType}/{scopeName}/privileges",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def grant_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        grant: Grant,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def grant_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        grant: Grant,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def grant_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        grant: Grant,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def grant_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        grant: Grant,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Grant the specified privilege(s) on the named securable to the named grantee.  # noqa: E501

        Endpoint to indicate that the privileges listed in the request body should be granted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_privilege(
        ...     grantee_type, grantee_name, securable_type, securable_name, grant, async_req=True
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param securable_type: String that specifies the type of resource that is being secured by a privilege. (required)
        :type securable_type: str
        :param securable_name: String that specifies the name of resource that is being secured by a privilege. (required)
        :type securable_name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.grant_privilege_with_http_info(
            grantee_type, grantee_name, securable_type, securable_name, grant, **kwargs
        )

    @validate_call
    def grant_privilege_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        grant: Grant,
        **kwargs,
    ):
        r"""Grant the specified privilege(s) on the named securable to the named grantee.  # noqa: E501

        Endpoint to indicate that the privileges listed in the request body should be granted.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_privilege_with_http_info(
        ...     grantee_type, grantee_name, securable_type, securable_name, grant, async_req=True
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param securable_type: String that specifies the type of resource that is being secured by a privilege. (required)
        :type securable_type: str
        :param securable_name: String that specifies the name of resource that is being secured by a privilege. (required)
        :type securable_name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["grantee_type", "grantee_name", "securable_type", "securable_name", "grant"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method grant_privilege")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        if _params["securable_type"]:
            _path_params["securableType"] = _params["securable_type"]

        if _params["securable_name"]:
            _path_params["securableName"] = _params["securable_name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["grant"] is not None:
            _body_params = _params["grant"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}/{securableType}/{securableName}/privileges",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_grants_to(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[Grant]: ...

    @overload
    def list_grants_to(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[Grant]]: ...

    @overload
    def list_grants_to(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]: ...

    @validate_call
    def list_grants_to(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:
        r"""List of privileges associated with this grantee type and name  # noqa: E501

        List the roles and privileges granted to the specified grantee using the output of SHOW GRANTS TO  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_to(grantee_type, grantee_name, show_limit, async_req=True)
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Grant], Future[Iterable[Grant]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_grants_to_with_http_info(grantee_type, grantee_name, show_limit, **kwargs)

    @validate_call
    def list_grants_to_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ):
        r"""List of privileges associated with this grantee type and name  # noqa: E501

        List the roles and privileges granted to the specified grantee using the output of SHOW GRANTS TO  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_to_with_http_info(grantee_type, grantee_name, show_limit, async_req=True)
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Grant], Future[Iterable[Grant]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["grantee_type", "grantee_name", "show_limit"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_grants_to")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        # process the query parameters
        _query_params = []

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[Grant]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def revoke_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def revoke_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def revoke_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def revoke_group_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Revoke the specified privilege on the specified all/future securable in the given scope from the named grantee.  # noqa: E501

        Endpoint to indicate that the privilege listed on the group securable in the given scope should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_group_privilege(
        ...     grantee_type,
        ...     grantee_name,
        ...     bulk_grant_type,
        ...     securable_type_plural,
        ...     scope_type,
        ...     scope_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param bulk_grant_type: String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type (required)
        :type bulk_grant_type: str
        :param securable_type_plural: String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either \"schemas\" or any plural object type that can nest under a schema such as \"tables\" (required)
        :type securable_type_plural: str
        :param scope_type: String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA (required)
        :type scope_type: str
        :param scope_name: String that specifies the name of resource that is the scope of an ALL/FUTURE privilege (required)
        :type scope_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.revoke_group_privilege_with_http_info(
            grantee_type,
            grantee_name,
            bulk_grant_type,
            securable_type_plural,
            scope_type,
            scope_name,
            privilege,
            delete_mode,
            **kwargs,
        )

    @validate_call
    def revoke_group_privilege_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ):
        r"""Revoke the specified privilege on the specified all/future securable in the given scope from the named grantee.  # noqa: E501

        Endpoint to indicate that the privilege listed on the group securable in the given scope should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_group_privilege_with_http_info(
        ...     grantee_type,
        ...     grantee_name,
        ...     bulk_grant_type,
        ...     securable_type_plural,
        ...     scope_type,
        ...     scope_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param bulk_grant_type: String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type (required)
        :type bulk_grant_type: str
        :param securable_type_plural: String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either \"schemas\" or any plural object type that can nest under a schema such as \"tables\" (required)
        :type securable_type_plural: str
        :param scope_type: String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA (required)
        :type scope_type: str
        :param scope_name: String that specifies the name of resource that is the scope of an ALL/FUTURE privilege (required)
        :type scope_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = [
            "grantee_type",
            "grantee_name",
            "bulk_grant_type",
            "securable_type_plural",
            "scope_type",
            "scope_name",
            "privilege",
            "delete_mode",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method revoke_group_privilege")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        if _params["bulk_grant_type"]:
            _path_params["bulkGrantType"] = _params["bulk_grant_type"]

        if _params["securable_type_plural"]:
            _path_params["securableTypePlural"] = _params["securable_type_plural"]

        if _params["scope_type"]:
            _path_params["scopeType"] = _params["scope_type"]

        if _params["scope_name"]:
            _path_params["scopeName"] = _params["scope_name"]

        if _params["privilege"]:
            _path_params["privilege"] = _params["privilege"]

        # process the query parameters
        _query_params = []

        if _params.get("delete_mode") is not None:
            _query_params.append(("deleteMode", _params["delete_mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}/{bulkGrantType}/{securableTypePlural}/{scopeType}/{scopeName}/privileges/{privilege}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def revoke_group_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def revoke_group_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def revoke_group_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def revoke_group_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Revoke the grant option for the specified privilege on the specified all/future securable in the given scope from the named grantee.  # noqa: E501

        Endpoint to indicate that the grant option for the privilege listed on the group securable in the given scope should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_group_privilege_grant_option(
        ...     grantee_type,
        ...     grantee_name,
        ...     bulk_grant_type,
        ...     securable_type_plural,
        ...     scope_type,
        ...     scope_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param bulk_grant_type: String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type (required)
        :type bulk_grant_type: str
        :param securable_type_plural: String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either \"schemas\" or any plural object type that can nest under a schema such as \"tables\" (required)
        :type securable_type_plural: str
        :param scope_type: String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA (required)
        :type scope_type: str
        :param scope_name: String that specifies the name of resource that is the scope of an ALL/FUTURE privilege (required)
        :type scope_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.revoke_group_privilege_grant_option_with_http_info(
            grantee_type,
            grantee_name,
            bulk_grant_type,
            securable_type_plural,
            scope_type,
            scope_name,
            privilege,
            delete_mode,
            **kwargs,
        )

    @validate_call
    def revoke_group_privilege_grant_option_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        bulk_grant_type: Annotated[
            StrictStr,
            Field(
                description="String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type"
            ),
        ],
        securable_type_plural: Annotated[
            StrictStr,
            Field(
                description='String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either "schemas" or any plural object type that can nest under a schema such as "tables"'
            ),
        ],
        scope_type: Annotated[
            StrictStr,
            Field(
                description="String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA"
            ),
        ],
        scope_name: Annotated[
            StrictStr,
            Field(
                description="String that specifies the name of resource that is the scope of an ALL/FUTURE privilege"
            ),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ):
        r"""Revoke the grant option for the specified privilege on the specified all/future securable in the given scope from the named grantee.  # noqa: E501

        Endpoint to indicate that the grant option for the privilege listed on the group securable in the given scope should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_group_privilege_grant_option_with_http_info(
        ...     grantee_type,
        ...     grantee_name,
        ...     bulk_grant_type,
        ...     securable_type_plural,
        ...     scope_type,
        ...     scope_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param bulk_grant_type: String that species whether this group privilege should be on ALL or FUTURE resources of the specified plural type (required)
        :type bulk_grant_type: str
        :param securable_type_plural: String that specifies the plural of the type of resource that is being secured by an ALL/FUTURE privilege. Must be either \"schemas\" or any plural object type that can nest under a schema such as \"tables\" (required)
        :type securable_type_plural: str
        :param scope_type: String that specifies the type of resource that is the scope of an ALL/FUTURE privilege. Can only be DATABASE or SCHEMA (required)
        :type scope_type: str
        :param scope_name: String that specifies the name of resource that is the scope of an ALL/FUTURE privilege (required)
        :type scope_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = [
            "grantee_type",
            "grantee_name",
            "bulk_grant_type",
            "securable_type_plural",
            "scope_type",
            "scope_name",
            "privilege",
            "delete_mode",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method revoke_group_privilege_grant_option"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        if _params["bulk_grant_type"]:
            _path_params["bulkGrantType"] = _params["bulk_grant_type"]

        if _params["securable_type_plural"]:
            _path_params["securableTypePlural"] = _params["securable_type_plural"]

        if _params["scope_type"]:
            _path_params["scopeType"] = _params["scope_type"]

        if _params["scope_name"]:
            _path_params["scopeName"] = _params["scope_name"]

        if _params["privilege"]:
            _path_params["privilege"] = _params["privilege"]

        # process the query parameters
        _query_params = []

        if _params.get("delete_mode") is not None:
            _query_params.append(("deleteMode", _params["delete_mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}/{bulkGrantType}/{securableTypePlural}/{scopeType}/{scopeName}/privileges/{privilege}/grant-option",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def revoke_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def revoke_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def revoke_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def revoke_privilege(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Revoke the specified privilege on the named securable from the named grantee.  # noqa: E501

        Endpoint to indicate that the privilege listed in the path should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_privilege(
        ...     grantee_type,
        ...     grantee_name,
        ...     securable_type,
        ...     securable_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param securable_type: String that specifies the type of resource that is being secured by a privilege. (required)
        :type securable_type: str
        :param securable_name: String that specifies the name of resource that is being secured by a privilege. (required)
        :type securable_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.revoke_privilege_with_http_info(
            grantee_type, grantee_name, securable_type, securable_name, privilege, delete_mode, **kwargs
        )

    @validate_call
    def revoke_privilege_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ):
        r"""Revoke the specified privilege on the named securable from the named grantee.  # noqa: E501

        Endpoint to indicate that the privilege listed in the path should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_privilege_with_http_info(
        ...     grantee_type,
        ...     grantee_name,
        ...     securable_type,
        ...     securable_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param securable_type: String that specifies the type of resource that is being secured by a privilege. (required)
        :type securable_type: str
        :param securable_name: String that specifies the name of resource that is being secured by a privilege. (required)
        :type securable_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["grantee_type", "grantee_name", "securable_type", "securable_name", "privilege", "delete_mode"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method revoke_privilege")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        if _params["securable_type"]:
            _path_params["securableType"] = _params["securable_type"]

        if _params["securable_name"]:
            _path_params["securableName"] = _params["securable_name"]

        if _params["privilege"]:
            _path_params["privilege"] = _params["privilege"]

        # process the query parameters
        _query_params = []

        if _params.get("delete_mode") is not None:
            _query_params.append(("deleteMode", _params["delete_mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}/{securableType}/{securableName}/privileges/{privilege}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def revoke_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def revoke_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def revoke_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def revoke_privilege_grant_option(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Revoke the grant option for the specified privilege on the named securable from the named grantee.  # noqa: E501

        Endpoint to indicate that the grant option for the privilege listed in the path should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_privilege_grant_option(
        ...     grantee_type,
        ...     grantee_name,
        ...     securable_type,
        ...     securable_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param securable_type: String that specifies the type of resource that is being secured by a privilege. (required)
        :type securable_type: str
        :param securable_name: String that specifies the name of resource that is being secured by a privilege. (required)
        :type securable_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.revoke_privilege_grant_option_with_http_info(
            grantee_type, grantee_name, securable_type, securable_name, privilege, delete_mode, **kwargs
        )

    @validate_call
    def revoke_privilege_grant_option_with_http_info(
        self,
        grantee_type: Annotated[
            StrictStr, Field(description="String that specifies the type of resource that is the privilege grantee.")
        ],
        grantee_name: Annotated[
            StrictStr, Field(description="String that specifies the name of the privilege grantee.")
        ],
        securable_type: Annotated[
            StrictStr,
            Field(description="String that specifies the type of resource that is being secured by a privilege."),
        ],
        securable_name: Annotated[
            StrictStr,
            Field(description="String that specifies the name of resource that is being secured by a privilege."),
        ],
        privilege: Annotated[StrictStr, Field(description="String that specifies a privilege to be revoked")],
        delete_mode: Annotated[
            Optional[StrictStr],
            Field(
                description='If "cascade", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are "restrict" or "cascade".'
            ),
        ] = None,
        **kwargs,
    ):
        r"""Revoke the grant option for the specified privilege on the named securable from the named grantee.  # noqa: E501

        Endpoint to indicate that the grant option for the privilege listed in the path should be revoked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_privilege_grant_option_with_http_info(
        ...     grantee_type,
        ...     grantee_name,
        ...     securable_type,
        ...     securable_name,
        ...     privilege,
        ...     delete_mode,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param grantee_type: String that specifies the type of resource that is the privilege grantee. (required)
        :type grantee_type: str
        :param grantee_name: String that specifies the name of the privilege grantee. (required)
        :type grantee_name: str
        :param securable_type: String that specifies the type of resource that is being secured by a privilege. (required)
        :type securable_type: str
        :param securable_name: String that specifies the name of resource that is being secured by a privilege. (required)
        :type securable_name: str
        :param privilege: String that specifies a privilege to be revoked (required)
        :type privilege: str
        :param delete_mode: If \"cascade\", recursively revoke the grant from sub-grantees to which this privilege was re-granted. Acceptable values are \"restrict\" or \"cascade\".
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["grantee_type", "grantee_name", "securable_type", "securable_name", "privilege", "delete_mode"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method revoke_privilege_grant_option"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["grantee_type"]:
            _path_params["granteeType"] = _params["grantee_type"]

        if _params["grantee_name"]:
            _path_params["granteeName"] = _params["grantee_name"]

        if _params["securable_type"]:
            _path_params["securableType"] = _params["securable_type"]

        if _params["securable_name"]:
            _path_params["securableName"] = _params["securable_name"]

        if _params["privilege"]:
            _path_params["privilege"] = _params["privilege"]

        # process the query parameters
        _query_params = []

        if _params.get("delete_mode") is not None:
            _query_params.append(("deleteMode", _params["delete_mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/grants/{granteeType}/{granteeName}/{securableType}/{securableName}/privileges/{privilege}/grant-option",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )
