"""
Snowflake Notification Integration API.

The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.notification_integration._generated.models.notification_hook import (
    NotificationHook,
    NotificationHookModel,
)


class NotificationIntegration(BaseModel):
    """A model object representing the NotificationIntegration resource.

    Constructs an object of type NotificationIntegration with the provided properties.

    Parameters
    __________
    name : str
        Name of the notification.
    notification_hook : NotificationHook

    enabled : bool, optional
        Whether the notification integration is enabled.
    comment : str, optional
        Comment for the notification integration.
    created_on : datetime, optional
        Date and time when the notification was created — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Annotated[str, Field(strict=True)]

    enabled: Optional[StrictBool] = None

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    notification_hook: NotificationHook

    __properties = ["name", "enabled", "comment", "created_on", "notification_hook"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationIntegration:
        """Create an instance of NotificationIntegration from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of notification_hook
        if self.notification_hook:
            _dict["notification_hook"] = self.notification_hook.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationIntegration:
        """Create an instance of NotificationIntegration from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NotificationIntegration.model_validate(obj)

        _obj = NotificationIntegration.model_validate(
            {
                "name": obj.get("name"),
                "enabled": obj.get("enabled"),
                "comment": obj.get("comment"),
                "created_on": obj.get("created_on"),
                "notification_hook": NotificationHook.from_dict(obj.get("notification_hook"))
                if obj.get("notification_hook") is not None
                else None,
            }
        )

        return _obj


class NotificationIntegrationModel:
    def __init__(
        self,
        name: str,
        notification_hook: NotificationHook,
        # optional properties
        enabled: Optional[bool] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
    ):
        """A model object representing the NotificationIntegration resource.

        Constructs an object of type NotificationIntegration with the provided properties.

        Parameters
        __________
        name : str
            Name of the notification.
        notification_hook : NotificationHook

        enabled : bool, optional
            Whether the notification integration is enabled.
        comment : str, optional
            Comment for the notification integration.
        created_on : datetime, optional
            Date and time when the notification was created.
        """
        self.name = name
        self.enabled = enabled
        self.comment = comment
        self.created_on = created_on
        self.notification_hook = notification_hook

    __properties = ["name", "enabled", "comment", "created_on", "notification_hook"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationIntegration(
            name=self.name,
            enabled=self.enabled,
            comment=self.comment,
            created_on=self.created_on,
            notification_hook=self.notification_hook._to_model() if self.notification_hook is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> NotificationIntegrationModel:
        return NotificationIntegrationModel(
            name=model.name,
            enabled=model.enabled,
            comment=model.comment,
            created_on=model.created_on,
            notification_hook=NotificationHookModel._from_model(model.notification_hook)
            if model.notification_hook
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a NotificationIntegration.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationIntegration object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationIntegrationModel:
        """Create an instance of NotificationIntegration from a dict.

        This method constructs a NotificationIntegration object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationIntegration
            A NotificationIntegration object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NotificationIntegration.from_dict(obj))


NotificationIntegration._model_class = NotificationIntegrationModel
