"""
Snowflake Role API.

The Snowflake Role API is a REST API that you can use to access, update, and perform certain actions on Role resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated


class Role(BaseModel):
    """A model object representing the Role resource.

    Constructs an object of type Role with the provided properties.

    Parameters
    __________
    name : str
        Name of the role.
    comment : str, optional
        Comment of the role.
    created_on : datetime, optional
        Date and time when the role was created — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Specifies the role that owns this role — **Read-only:** *any user-provided value will be ignored.*
    is_default : bool, optional
        Specifies whether the role being fetched is the user's default role — **Read-only:** *any user-provided value will be ignored.*
    is_current : bool, optional
        Specifies whether the role being fetched is the user's current role — **Read-only:** *any user-provided value will be ignored.*
    is_inherited : bool, optional
        Specifies whether the role used to run the command inherits the specified role — **Read-only:** *any user-provided value will be ignored.*
    assigned_to_users : int, optional
        The number of users to whom this role has been assigned — **Read-only:** *any user-provided value will be ignored.*
    granted_to_roles : int, optional
        The number of roles to which this role has been granted — **Read-only:** *any user-provided value will be ignored.*
    granted_roles : int, optional
        The number of roles that have been granted to this role — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Annotated[str, Field(strict=True)]

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    is_default: Optional[StrictBool] = None

    is_current: Optional[StrictBool] = None

    is_inherited: Optional[StrictBool] = None

    assigned_to_users: Optional[StrictInt] = None

    granted_to_roles: Optional[StrictInt] = None

    granted_roles: Optional[StrictInt] = None

    __properties = [
        "name",
        "comment",
        "created_on",
        "owner",
        "is_default",
        "is_current",
        "is_inherited",
        "assigned_to_users",
        "granted_to_roles",
        "granted_roles",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Role:
        """Create an instance of Role from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "owner",
                    "is_default",
                    "is_current",
                    "is_inherited",
                    "assigned_to_users",
                    "granted_to_roles",
                    "granted_roles",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Role:
        """Create an instance of Role from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Role.model_validate(obj)

        _obj = Role.model_validate(
            {
                "name": obj.get("name"),
                "comment": obj.get("comment"),
                "created_on": obj.get("created_on"),
                "owner": obj.get("owner"),
                "is_default": obj.get("is_default"),
                "is_current": obj.get("is_current"),
                "is_inherited": obj.get("is_inherited"),
                "assigned_to_users": obj.get("assigned_to_users"),
                "granted_to_roles": obj.get("granted_to_roles"),
                "granted_roles": obj.get("granted_roles"),
            }
        )

        return _obj


class RoleModel:
    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        owner: Optional[str] = None,
        is_default: Optional[bool] = None,
        is_current: Optional[bool] = None,
        is_inherited: Optional[bool] = None,
        assigned_to_users: Optional[int] = None,
        granted_to_roles: Optional[int] = None,
        granted_roles: Optional[int] = None,
    ):
        """A model object representing the Role resource.

        Constructs an object of type Role with the provided properties.

        Parameters
        __________
        name : str
            Name of the role.
        comment : str, optional
            Comment of the role.
        created_on : datetime, optional
            Date and time when the role was created.
        owner : str, optional
            Specifies the role that owns this role.
        is_default : bool, optional
            Specifies whether the role being fetched is the user's default role.
        is_current : bool, optional
            Specifies whether the role being fetched is the user's current role.
        is_inherited : bool, optional
            Specifies whether the role used to run the command inherits the specified role.
        assigned_to_users : int, optional
            The number of users to whom this role has been assigned.
        granted_to_roles : int, optional
            The number of roles to which this role has been granted.
        granted_roles : int, optional
            The number of roles that have been granted to this role.
        """
        self.name = name
        self.comment = comment
        self.created_on = created_on
        self.owner = owner
        self.is_default = is_default
        self.is_current = is_current
        self.is_inherited = is_inherited
        self.assigned_to_users = assigned_to_users
        self.granted_to_roles = granted_to_roles
        self.granted_roles = granted_roles

    __properties = [
        "name",
        "comment",
        "created_on",
        "owner",
        "is_default",
        "is_current",
        "is_inherited",
        "assigned_to_users",
        "granted_to_roles",
        "granted_roles",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Role(
            name=self.name,
            comment=self.comment,
            created_on=self.created_on,
            owner=self.owner,
            is_default=self.is_default,
            is_current=self.is_current,
            is_inherited=self.is_inherited,
            assigned_to_users=self.assigned_to_users,
            granted_to_roles=self.granted_to_roles,
            granted_roles=self.granted_roles,
        )

    @classmethod
    def _from_model(cls, model) -> RoleModel:
        return RoleModel(
            name=model.name,
            comment=model.comment,
            created_on=model.created_on,
            owner=model.owner,
            is_default=model.is_default,
            is_current=model.is_current,
            is_inherited=model.is_inherited,
            assigned_to_users=model.assigned_to_users,
            granted_to_roles=model.granted_to_roles,
            granted_roles=model.granted_roles,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Role.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Role object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> RoleModel:
        """Create an instance of Role from a dict.

        This method constructs a Role object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Role
            A Role object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Role.from_dict(obj))


Role._model_class = RoleModel
