"""
Snowflake Stage API.

The Snowflake Stage API is a REST API that you can use to access, update, and perform certain actions on stage resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, SecretStr, StrictStr, field_validator


class StageEncryption(BaseModel):
    """A model object representing the StageEncryption resource.

    Constructs an object of type StageEncryption with the provided properties.

    Parameters
    __________
    type : str, optional
        Specifies the encryption type used.
    master_key : str, optional
        Specifies the client-side master key used to encrypt the files in the bucket. The master key must be a 128-bit or 256-bit key in Base64-encoded form.
    kms_key_id : str, optional
        Optionally specifies the ID for the KMS-managed key used to encrypt files unloaded into the bucket.
    """

    type: Optional[StrictStr] = None

    master_key: Optional[SecretStr] = None

    kms_key_id: Optional[StrictStr] = None

    __properties = ["type", "master_key", "kms_key_id"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in (
            "SNOWFLAKE_FULL",
            "SNOWFLAKE_SSE",
            "AWS_CSE",
            "AWS_SSE_S3",
            "AWS_SSE_KMS",
            "GCS_SSE_KMS",
            "AZURE_CSE",
            "NONE",
        ):
            raise ValueError(
                "must validate the enum values ('SNOWFLAKE_FULL','SNOWFLAKE_SSE','AWS_CSE','AWS_SSE_S3','AWS_SSE_KMS','GCS_SSE_KMS','AZURE_CSE','NONE')"
            )
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StageEncryption:
        """Create an instance of StageEncryption from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StageEncryption:
        """Create an instance of StageEncryption from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StageEncryption.model_validate(obj)

        _obj = StageEncryption.model_validate(
            {
                "type": obj.get("type"),
                "master_key": obj.get("master_key"),
                "kms_key_id": obj.get("kms_key_id"),
            }
        )

        return _obj


class StageEncryptionModel:
    def __init__(
        self,  # optional properties
        type: Optional[str] = None,
        master_key: Optional[str] = None,
        kms_key_id: Optional[str] = None,
    ):
        """A model object representing the StageEncryption resource.

        Constructs an object of type StageEncryption with the provided properties.

        Parameters
        __________
        type : str, optional
            Specifies the encryption type used.
        master_key : str, optional
            Specifies the client-side master key used to encrypt the files in the bucket. The master key must be a 128-bit or 256-bit key in Base64-encoded form.
        kms_key_id : str, optional
            Optionally specifies the ID for the KMS-managed key used to encrypt files unloaded into the bucket.
        """
        self.type = type
        self.master_key = master_key
        self.kms_key_id = kms_key_id

    __properties = ["type", "master_key", "kms_key_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StageEncryption(
            type=self.type,
            master_key=self.master_key,
            kms_key_id=self.kms_key_id,
        )

    @classmethod
    def _from_model(cls, model) -> StageEncryptionModel:
        return StageEncryptionModel(
            type=model.type,
            master_key=model.master_key,
            kms_key_id=model.kms_key_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StageEncryption.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StageEncryption object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StageEncryptionModel:
        """Create an instance of StageEncryption from a dict.

        This method constructs a StageEncryption object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StageEncryption
            A StageEncryption object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StageEncryption.from_dict(obj))


StageEncryption._model_class = StageEncryptionModel
