"""
Snowflake Table API.

The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.table._generated.models.point_of_time import PointOfTime


class PointOfTimeOffset(PointOfTime):
    """A model object representing the PointOfTimeOffset resource.

    Constructs an object of type PointOfTimeOffset with the provided properties.

    Parameters
    __________

    reference : str, optional
        Relation to the point of time. Currently, the API supports `at` and `before`.

    offset : str, optional
        The difference in seconds from the current time in the form -N where N can be an integer or arithmetic expression (e.g. -120).
    """

    offset: Optional[StrictStr] = None

    __properties = ["point_of_time_type", "reference"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PointOfTimeOffset:
        """Create an instance of PointOfTimeOffset from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["point_of_time_type"] = PointOfTime.get_child_model_discriminator_value("PointOfTimeOffset")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PointOfTimeOffset:
        """Create an instance of PointOfTimeOffset from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PointOfTimeOffset.model_validate(obj)

        _obj = PointOfTimeOffset.model_validate(
            {
                "reference": obj.get("reference"),
                "offset": obj.get("offset"),
            }
        )

        return _obj


class PointOfTimeOffsetModel(PointOfTime):
    def __init__(
        self,  # optional properties
        reference: Optional[str] = None,
        offset: Optional[str] = None,
    ):
        """A model object representing the PointOfTimeOffset resource.

        Constructs an object of type PointOfTimeOffset with the provided properties.

        Parameters
        __________

        reference : str, optional
            Relation to the point of time. Currently, the API supports `at` and `before`.

        offset : str, optional
            The difference in seconds from the current time in the form -N where N can be an integer or arithmetic expression (e.g. -120).
        """
        super().__init__(
            reference=reference,
        )
        self.offset = offset

    __properties = ["point_of_time_type", "reference"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PointOfTimeOffset(
            reference=self.reference,
            offset=self.offset,
        )

    @classmethod
    def _from_model(cls, model) -> PointOfTimeOffsetModel:
        return PointOfTimeOffsetModel(
            reference=model.reference,
            offset=model.offset,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PointOfTimeOffset.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PointOfTimeOffset object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PointOfTimeOffsetModel:
        """Create an instance of PointOfTimeOffset from a dict.

        This method constructs a PointOfTimeOffset object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PointOfTimeOffset
            A PointOfTimeOffset object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PointOfTimeOffset.from_dict(obj))


PointOfTimeOffset._model_class = PointOfTimeOffsetModel
