"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import json
import logging
import os
import re
import tempfile

from concurrent.futures import Future
from datetime import date, datetime
from typing import Iterable, List, Literal, Optional, Union, overload

from dateutil.parser import parse
from pydantic import Field, StrictBool, StrictStr, validate_call
from typing_extensions import Annotated

import snowflake.core._http_requests

from snowflake.core._generated import rest
from snowflake.core._generated.api_client import ApiClient
from snowflake.core._internal.utils import is_running_inside_stored_procedure
from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError,
    _APIValueError,
)
from snowflake.core.user_defined_function._generated import models
from snowflake.core.user_defined_function._generated.models.success_response import SuccessResponse
from snowflake.core.user_defined_function._generated.models.tag_assignment import TagAssignment
from snowflake.core.user_defined_function._generated.models.tag_reference import TagReference
from snowflake.core.user_defined_function._generated.models.user_defined_function import UserDefinedFunction
from snowflake.core.user_defined_function._generated.models.user_defined_function_argument import (
    UserDefinedFunctionArgument,
)


logger = logging.getLogger(__name__)


class UserDefinedFunctionApi:
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = "user_defined_function"
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default()

    @property
    def api_client(self):
        return self._api_client

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if isinstance(klass, str):
            if klass.startswith("Iterable["):
                sub_kls = re.match(r"Iterable\[(.*)]", klass).group(1)
                return [self.__deserialize(sub_data, sub_kls) for sub_data in data]

            if klass.startswith("Dict["):
                sub_kls = re.match(r"Dict\[([^,]*), (.*)]", klass).group(2)
                return {k: self.__deserialize(v, sub_kls) for k, v in data.items()}

            # convert str to class
            if klass in snowflake.core._http_requests.NATIVE_TYPES_MAPPING:
                klass = snowflake.core._http_requests.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in snowflake.core._http_requests.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:  # noqa: E721
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def __deserialize_file(self, response):
        """Deserializes body to file.

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.api_client.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=f"Failed to parse `{string}` as date object")

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=(f"Failed to parse `{string}` as datetime object"))

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        return klass.from_dict(data)

    @overload
    def create_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        user_defined_function: UserDefinedFunction,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        user_defined_function: UserDefinedFunction,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        user_defined_function: UserDefinedFunction,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        user_defined_function: UserDefinedFunction,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a UDF  # noqa: E501

        Create a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_user_defined_function(
        ...     database, var_schema, user_defined_function, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param user_defined_function: (required)
        :type user_defined_function: UserDefinedFunction
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_user_defined_function_with_http_info(
            database, var_schema, user_defined_function, create_mode, copy_grants, **kwargs
        )

    @validate_call
    def create_user_defined_function_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        user_defined_function: UserDefinedFunction,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        copy_grants: Annotated[
            Optional[StrictBool], Field(description="Parameter to enable copy grants when creating the object.")
        ] = None,
        **kwargs,
    ):
        r"""Create a UDF  # noqa: E501

        Create a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_user_defined_function_with_http_info(
        ...     database, var_schema, user_defined_function, create_mode, copy_grants, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param user_defined_function: (required)
        :type user_defined_function: UserDefinedFunction
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param copy_grants: Parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "user_defined_function", "create_mode", "copy_grants"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method create_user_defined_function"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        if _params.get("copy_grants") is not None:
            _query_params.append(("copyGrants", _params["copy_grants"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["user_defined_function"] is not None:
            _body_params = _params["user_defined_function"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def execute_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> object: ...

    @overload
    def execute_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[object]: ...

    @overload
    def execute_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[object, Future[object]]: ...

    @validate_call
    def execute_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
        **kwargs,
    ) -> Union[object, Future[object]]:
        r"""Execute a UDF.  # noqa: E501

        Execute a UDF.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_user_defined_function(
        ...     database, var_schema, name, user_defined_function_argument, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param user_defined_function_argument:
        :type user_defined_function_argument: List[UserDefinedFunctionArgument]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[object, Future[object]]
        """
        kwargs["_return_http_data_only"] = True
        return self.execute_user_defined_function_with_http_info(
            database, var_schema, name, user_defined_function_argument, **kwargs
        )

    @validate_call
    def execute_user_defined_function_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
        **kwargs,
    ):
        r"""Execute a UDF.  # noqa: E501

        Execute a UDF.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.execute_user_defined_function_with_http_info(
        ...     database, var_schema, name, user_defined_function_argument, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param user_defined_function_argument:
        :type user_defined_function_argument: List[UserDefinedFunctionArgument]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[object, Future[object]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name", "user_defined_function_argument"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method execute_user_defined_function"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["user_defined_function_argument"] is not None:
            _body_params = _params["user_defined_function_argument"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "object",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{name}:execute",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def fetch_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        async_req: Literal[False] = False,
        **kwargs,
    ) -> UserDefinedFunction: ...

    @overload
    def fetch_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[UserDefinedFunction]: ...

    @overload
    def fetch_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        async_req: bool = False,
        **kwargs,
    ) -> Union[UserDefinedFunction, Future[UserDefinedFunction]]: ...

    @validate_call
    def fetch_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        **kwargs,
    ) -> Union[UserDefinedFunction, Future[UserDefinedFunction]]:
        r"""Fetch a UDF  # noqa: E501

        Fetch a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_user_defined_function(database, var_schema, name_with_args, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[UserDefinedFunction, Future[UserDefinedFunction]]
        """
        kwargs["_return_http_data_only"] = True
        return self.fetch_user_defined_function_with_http_info(database, var_schema, name_with_args, **kwargs)

    @validate_call
    def fetch_user_defined_function_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        **kwargs,
    ):
        r"""Fetch a UDF  # noqa: E501

        Fetch a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_user_defined_function_with_http_info(
        ...     database, var_schema, name_with_args, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[UserDefinedFunction, Future[UserDefinedFunction]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name_with_args"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method fetch_user_defined_function"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name_with_args"]:
            _path_params["nameWithArgs"] = _params["name_with_args"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "UserDefinedFunction",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{nameWithArgs}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def get_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[TagAssignment]: ...

    @overload
    def get_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[TagAssignment]]: ...

    @overload
    def get_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]: ...

    @validate_call
    def get_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]:
        r"""Get the tag assignments for a user-defined function.  # noqa: E501

        Returns all tags assigned to a user-defined function. This operation requires an active warehouse.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_tags(database, var_schema, name_with_args, with_lineage, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param with_lineage: Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        :type with_lineage: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.get_tags_with_http_info(database, var_schema, name_with_args, with_lineage, **kwargs)

    @validate_call
    def get_tags_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Get the tag assignments for a user-defined function.  # noqa: E501

        Returns all tags assigned to a user-defined function. This operation requires an active warehouse.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_tags_with_http_info(
        ...     database, var_schema, name_with_args, with_lineage, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param with_lineage: Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        :type with_lineage: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name_with_args", "with_lineage"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method get_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name_with_args"]:
            _path_params["nameWithArgs"] = _params["name_with_args"]

        # process the query parameters
        _query_params = []

        if _params.get("with_lineage") is not None:
            _query_params.append(("withLineage", _params["with_lineage"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[TagAssignment]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{nameWithArgs}:get-tags",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_user_defined_functions(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[UserDefinedFunction]: ...

    @overload
    def list_user_defined_functions(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[UserDefinedFunction]]: ...

    @overload
    def list_user_defined_functions(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[UserDefinedFunction], Future[Iterable[UserDefinedFunction]]]: ...

    @validate_call
    def list_user_defined_functions(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[UserDefinedFunction], Future[Iterable[UserDefinedFunction]]]:
        r"""List UDFs  # noqa: E501

        List UDFs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_user_defined_functions(database, var_schema, like, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[UserDefinedFunction], Future[Iterable[UserDefinedFunction]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_user_defined_functions_with_http_info(database, var_schema, like, **kwargs)

    @validate_call
    def list_user_defined_functions_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        **kwargs,
    ):
        r"""List UDFs  # noqa: E501

        List UDFs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_user_defined_functions_with_http_info(database, var_schema, like, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[UserDefinedFunction], Future[Iterable[UserDefinedFunction]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "like"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method list_user_defined_functions"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        # process the query parameters
        _query_params = []

        if _params.get("like") is not None:
            _query_params.append(("like", _params["like"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[UserDefinedFunction]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def rename_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        target_database: Annotated[
            str, Field(strict=True, description="Database of the target resource. Defaults to the source's database")
        ],
        target_schema: Annotated[
            str, Field(strict=True, description="Schema of the target resource. Defaults to the source's schema")
        ],
        target_name: Annotated[str, Field(strict=True, description="Name of the target resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def rename_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        target_database: Annotated[
            str, Field(strict=True, description="Database of the target resource. Defaults to the source's database")
        ],
        target_schema: Annotated[
            str, Field(strict=True, description="Schema of the target resource. Defaults to the source's schema")
        ],
        target_name: Annotated[str, Field(strict=True, description="Name of the target resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def rename_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        target_database: Annotated[
            str, Field(strict=True, description="Database of the target resource. Defaults to the source's database")
        ],
        target_schema: Annotated[
            str, Field(strict=True, description="Schema of the target resource. Defaults to the source's schema")
        ],
        target_name: Annotated[str, Field(strict=True, description="Name of the target resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def rename_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        target_database: Annotated[
            str, Field(strict=True, description="Database of the target resource. Defaults to the source's database")
        ],
        target_schema: Annotated[
            str, Field(strict=True, description="Schema of the target resource. Defaults to the source's schema")
        ],
        target_name: Annotated[str, Field(strict=True, description="Name of the target resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Rename a UDF  # noqa: E501

        Rename a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.rename_user_defined_function(
        ...     database,
        ...     var_schema,
        ...     name_with_args,
        ...     target_database,
        ...     target_schema,
        ...     target_name,
        ...     if_exists,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param target_database: Database of the target resource. Defaults to the source's database (required)
        :type target_database: str
        :param target_schema: Schema of the target resource. Defaults to the source's schema (required)
        :type target_schema: str
        :param target_name: Name of the target resource. (required)
        :type target_name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.rename_user_defined_function_with_http_info(
            database, var_schema, name_with_args, target_database, target_schema, target_name, if_exists, **kwargs
        )

    @validate_call
    def rename_user_defined_function_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        target_database: Annotated[
            str, Field(strict=True, description="Database of the target resource. Defaults to the source's database")
        ],
        target_schema: Annotated[
            str, Field(strict=True, description="Schema of the target resource. Defaults to the source's schema")
        ],
        target_name: Annotated[str, Field(strict=True, description="Name of the target resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Rename a UDF  # noqa: E501

        Rename a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.rename_user_defined_function_with_http_info(
        ...     database,
        ...     var_schema,
        ...     name_with_args,
        ...     target_database,
        ...     target_schema,
        ...     target_name,
        ...     if_exists,
        ...     async_req=True,
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param target_database: Database of the target resource. Defaults to the source's database (required)
        :type target_database: str
        :param target_schema: Schema of the target resource. Defaults to the source's schema (required)
        :type target_schema: str
        :param target_name: Name of the target resource. (required)
        :type target_name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = [
            "database",
            "var_schema",
            "name_with_args",
            "target_database",
            "target_schema",
            "target_name",
            "if_exists",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method rename_user_defined_function"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name_with_args"]:
            _path_params["nameWithArgs"] = _params["name_with_args"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        if _params.get("target_database") is not None:
            _query_params.append(("targetDatabase", _params["target_database"]))

        if _params.get("target_schema") is not None:
            _query_params.append(("targetSchema", _params["target_schema"]))

        if _params.get("target_name") is not None:
            _query_params.append(("targetName", _params["target_name"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{nameWithArgs}:rename",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def set_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def set_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def set_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def set_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Set tags on a user-defined function.  # noqa: E501

        Set tags on a user-defined function.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_tags(
        ...     database, var_schema, name_with_args, tag_assignment, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param tag_assignment: (required)
        :type tag_assignment: List[TagAssignment]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.set_tags_with_http_info(database, var_schema, name_with_args, tag_assignment, if_exists, **kwargs)

    @validate_call
    def set_tags_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Set tags on a user-defined function.  # noqa: E501

        Set tags on a user-defined function.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_tags_with_http_info(
        ...     database, var_schema, name_with_args, tag_assignment, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param tag_assignment: (required)
        :type tag_assignment: List[TagAssignment]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name_with_args", "tag_assignment", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method set_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name_with_args"]:
            _path_params["nameWithArgs"] = _params["name_with_args"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["tag_assignment"] is not None:
            _body_params = _params["tag_assignment"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{nameWithArgs}:set-tags",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def unset_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def unset_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def unset_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def unset_tags(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Unset tags from a user-defined function.  # noqa: E501

        Unset tags from a user-defined function.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.unset_tags(
        ...     database, var_schema, name_with_args, tag_reference, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param tag_reference: (required)
        :type tag_reference: List[TagReference]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.unset_tags_with_http_info(database, var_schema, name_with_args, tag_reference, if_exists, **kwargs)

    @validate_call
    def unset_tags_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Unset tags from a user-defined function.  # noqa: E501

        Unset tags from a user-defined function.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.unset_tags_with_http_info(
        ...     database, var_schema, name_with_args, tag_reference, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param tag_reference: (required)
        :type tag_reference: List[TagReference]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name_with_args", "tag_reference", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method unset_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name_with_args"]:
            _path_params["nameWithArgs"] = _params["name_with_args"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["tag_reference"] is not None:
            _body_params = _params["tag_reference"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{nameWithArgs}:unset-tags",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def delete_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def delete_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def delete_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def delete_user_defined_function(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Delete a UDF  # noqa: E501

        Delete a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_user_defined_function(
        ...     database, var_schema, name_with_args, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_user_defined_function_with_http_info(
            database, var_schema, name_with_args, if_exists, **kwargs
        )

    @validate_call
    def delete_user_defined_function_with_http_info(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases.",
            ),
        ],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description="Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database.",
            ),
        ],
        name_with_args: Annotated[StrictStr, Field(description="Function's name with Args")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Delete a UDF  # noqa: E501

        Delete a UDF  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_user_defined_function_with_http_info(
        ...     database, var_schema, name_with_args, if_exists, async_req=True
        ... )
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["database", "var_schema", "name_with_args", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(
                    f"Got an unexpected keyword argument '{_key}' to method delete_user_defined_function"
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["database"]:
            _path_params["database"] = _params["database"]

        if _params["var_schema"]:
            _path_params["schema"] = _params["var_schema"]

        if _params["name_with_args"]:
            _path_params["nameWithArgs"] = _params["name_with_args"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/databases/{database}/schemas/{schema}/user-defined-functions/{nameWithArgs}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )
