"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from typing import TYPE_CHECKING, Any, Iterator, List, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.tag import TagResource, TagValue
from snowflake.core.user_defined_function._generated.models.tag_assignment import TagAssignment
from snowflake.core.user_defined_function._generated.models.tag_reference import TagReference
from snowflake.core.user_defined_function._generated.models.user_defined_function import UserDefinedFunction
from snowflake.core.user_defined_function._generated.models.user_defined_function_argument import (
    UserDefinedFunctionArgument,
)

from .user_defined_function_api import UserDefinedFunctionApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class UserDefinedFunctionCollectionBase(SchemaObjectCollectionParent["UserDefinedFunctionResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = UserDefinedFunctionApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(
        self,
        user_defined_function: UserDefinedFunction,
        mode: Optional[Union[CreateMode, str]] = None,
        copy_grants: Optional[bool] = None,
    ) -> "UserDefinedFunctionResource":  # noqa: F821
        """Create a UDF.

        Parameters
        __________
        user_defined_function: UserDefinedFunction
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        copy_grants: bool
             Parameter to enable copy grants when creating the object.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_user_defined_function(
            self.database.name,
            self.schema.name,
            user_defined_function=user_defined_function,
            create_mode=mode,
            copy_grants=copy_grants,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(user_defined_function), self)
        return self._ref_class(user_defined_function.name, self)

    @api_telemetry
    def create_async(
        self,
        user_defined_function: UserDefinedFunction,
        mode: Optional[Union[CreateMode, str]] = None,
        copy_grants: Optional[bool] = None,
    ) -> PollingOperation["UserDefinedFunctionResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_user_defined_function(
            self.database.name,
            self.schema.name,
            user_defined_function=user_defined_function,
            create_mode=mode,
            copy_grants=copy_grants,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(
                future, lambda _: self._ref_class(get_function_name_with_args(user_defined_function), self)
            )
        return PollingOperation(
            future,
            lambda _: self._ref_class(
                user_defined_function if isinstance(user_defined_function, str) else user_defined_function.name, self
            ),
        )

    @api_telemetry
    def iter(self, *, like: Optional[str] = None) -> Iterator[UserDefinedFunction]:
        """List UDFs.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        """
        resources = self._api.list_user_defined_functions(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(self, *, like: Optional[str] = None) -> PollingOperation[Iterator[UserDefinedFunction]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self._api.list_user_defined_functions(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class UserDefinedFunctionResourceBase(SchemaObjectReferenceMixin["UserDefinedFunctionCollection"]):
    _collection_class: UserDefinedFunctionCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: UserDefinedFunctionCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def execute(
        self,
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
    ) -> object:
        """Execute a UDF.

        Parameters
        __________
        user_defined_function_argument: List[UserDefinedFunctionArgument]
        """
        result = self.collection._api.execute_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            user_defined_function_argument=user_defined_function_argument,
            async_req=False,
        )
        return result

    @api_telemetry
    def execute_async(
        self,
        user_defined_function_argument: Optional[List[UserDefinedFunctionArgument]] = None,
    ) -> PollingOperation[object]:
        """An asynchronous version of :func:`execute`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.execute_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            user_defined_function_argument=user_defined_function_argument,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def fetch(
        self,
    ) -> UserDefinedFunction:
        """Fetch a UDF.

        Parameters
        __________
        """
        result = self.collection._api.fetch_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )
        return result

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[UserDefinedFunction]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def get_tags(
        self,
        with_lineage: Optional[bool] = None,
    ) -> dict[TagResource, TagValue]:
        """Get the tag assignments for a user-defined function.

        Returns all tags assigned to a user-defined function. This operation requires an active warehouse.

        Parameters
        __________
        with_lineage: bool
             Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        """
        result = self.collection._api.get_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            with_lineage=with_lineage,
            async_req=False,
        )
        result = dict(self._to_get_tags_tuple(tag_assignment) for tag_assignment in result)
        return result

    @api_telemetry
    def get_tags_async(
        self,
        with_lineage: Optional[bool] = None,
    ) -> PollingOperation[dict[TagResource, TagValue]]:
        """An asynchronous version of :func:`get_tags`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.get_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            with_lineage=with_lineage,
            async_req=True,
        )
        return PollingOperation(
            future, lambda tag_assignments: dict(self._to_get_tags_tuple(ta) for ta in tag_assignments)
        )

    def _to_get_tags_tuple(self, ta: TagAssignment) -> tuple[TagResource, TagValue]:
        db = ta.tag_database
        schema = ta.tag_schema

        if db is None:
            raise ValueError("TagAssignment must have tag_database set.")

        if schema is None:
            raise ValueError("TagAssignment must have tag_schema set.")

        tag_resource = self.root.databases[db].schemas[schema].tags[ta.tag_name]
        tag_value = TagValue(ta.tag_value, ta.level)
        return tag_resource, tag_value

    @api_telemetry
    def rename(
        self,
        target_database: str,
        target_schema: str,
        target_name: str,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Rename a UDF.

        Parameters
        __________
        target_database: str
             Database of the target resource. Defaults to the source's database (required)
        target_schema: str
             Schema of the target resource. Defaults to the source's schema (required)
        target_name: str
             Name of the target resource. (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.rename_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_database=target_database,
            target_schema=target_schema,
            target_name=target_name,
            if_exists=if_exists,
            async_req=False,
        )

        self._rename_finalizer(target_name, target_schema, target_database)

    @api_telemetry
    def rename_async(
        self,
        target_database: str,
        target_schema: str,
        target_name: str,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`rename`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.rename_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_database=target_database,
            target_schema=target_schema,
            target_name=target_name,
            if_exists=if_exists,
            async_req=True,
        )

        def finalize(_: Any) -> None:
            self._rename_finalizer(
                target_name=target_name, target_schema=target_schema, target_database=target_database
            )

        return PollingOperation(future, finalize)

    def _rename_finalizer(self, target_name: str, target_schema: Optional[str], target_database: Optional[str]) -> None:
        """Finalizer for rename operation."""
        self._set_new_name(target_name)
        if target_database is None:
            target_database = self.database.name
        if target_schema is None:
            target_schema = self.schema.name

        # Schema level resource
        if target_database != self.database.name or target_schema != self.schema.name:
            self.collection = getattr(self.root.databases[target_database].schemas[target_schema], self._plural_name)

    @api_telemetry
    def set_tags(
        self,
        tags: dict[TagResource, TagValue],
        if_exists: Optional[bool] = None,
    ) -> None:
        """Set tags on a user-defined function.

        Parameters
        __________
        tags: dict[TagResource, TagValue]
             (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        tag_assignment = [
            self._to_tag_assignment(tag_resource, tag_value) for [tag_resource, tag_value] in tags.items()
        ]
        self.collection._api.set_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_assignment=tag_assignment,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def set_tags_async(
        self,
        tags: dict[TagResource, TagValue],
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`set_tags`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        tag_assignment = [
            self._to_tag_assignment(tag_resource, tag_value) for [tag_resource, tag_value] in tags.items()
        ]
        future = self.collection._api.set_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_assignment=tag_assignment,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @staticmethod
    def _to_tag_assignment(tag_resource: TagResource, tag_value: TagValue) -> TagAssignment:
        return TagAssignment(
            tag_name=tag_resource.name,
            tag_schema=tag_resource.schema.name,
            tag_database=tag_resource.database.name,
            tag_value=tag_value.value,
        )

    @api_telemetry
    def unset_tags(
        self,
        tag_resources: set[TagResource],
        if_exists: Optional[bool] = None,
    ) -> None:
        """Unset tags from a user-defined function.

        Parameters
        __________
        tag_resources: set[TagResource]
             (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        tag_reference = [self._to_tag_reference(tag_resource) for tag_resource in tag_resources]
        self.collection._api.unset_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_reference=tag_reference,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def unset_tags_async(
        self,
        tag_resources: set[TagResource],
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`unset_tags`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        tag_reference = [self._to_tag_reference(tag_resource) for tag_resource in tag_resources]
        future = self.collection._api.unset_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_reference=tag_reference,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @staticmethod
    def _to_tag_reference(resource: TagResource) -> TagReference:
        return TagReference(
            tag_name=resource.name,
            tag_schema=resource.schema.name,
            tag_database=resource.database.name,
        )

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a UDF.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_user_defined_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
