"""
Snowflake User Defined Function API.

The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.user_defined_function._generated.models.base_language import BaseLanguage


class PythonFunction(BaseLanguage):
    """A model object representing the PythonFunction resource.

    Constructs an object of type PythonFunction with the provided properties.

    Parameters
    __________

    packages : list[str]
        Packages to include with the function/procedure

    handler : str
        Fully qualified method name including the package and the class
    runtime_version : str
        Specifies the Python version to use. The supported versions of Python are:
                                * 3.8
                                * 3.9
                                * 3.10
                                * 3.11

    imports : list[str], optional
        List of imports

    external_access_integrations : list[str], optional
        List of external access integrations attached to this function/procedure
    secrets : str, optional
        Secrets to be used with this function/procedure for external access
    """

    external_access_integrations: Optional[List[StrictStr]] = None

    secrets: Optional[Dict[str, StrictStr]] = None

    runtime_version: StrictStr

    __properties = ["packages", "imports", "handler", "language", "called_on_null_input", "is_volatile"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PythonFunction:
        """Create an instance of PythonFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["language"] = BaseLanguage.get_child_model_discriminator_value("PythonFunction")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PythonFunction:
        """Create an instance of PythonFunction from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PythonFunction.model_validate(obj)

        _obj = PythonFunction.model_validate(
            {
                "packages": obj.get("packages"),
                "imports": obj.get("imports"),
                "handler": obj.get("handler"),
                "external_access_integrations": obj.get("external_access_integrations"),
                "secrets": obj.get("secrets"),
                "runtime_version": obj.get("runtime_version"),
            }
        )

        return _obj


class PythonFunctionModel(BaseLanguage):
    def __init__(
        self,
        packages: list[str],
        handler: str,
        runtime_version: str,
        # optional properties
        called_on_null_input: Optional[bool] = None,
        is_volatile: Optional[bool] = None,
        external_access_integrations: Optional[list[str]] = None,
        secrets: Optional[str] = None,
    ):
        """A model object representing the PythonFunction resource.

        Constructs an object of type PythonFunction with the provided properties.

        Parameters
        __________

        packages : list[str]
            Packages to include with the function/procedure

        handler : str
            Fully qualified method name including the package and the class
        runtime_version : str
            Specifies the Python version to use. The supported versions of Python are:
                        * 3.8
                        * 3.9
                        * 3.10
                        * 3.11

        imports : list[str], optional
            List of imports

        external_access_integrations : list[str], optional
            List of external access integrations attached to this function/procedure
        secrets : str, optional
            Secrets to be used with this function/procedure for external access
        """
        super().__init__(
            called_on_null_input=called_on_null_input,
            is_volatile=is_volatile,
        )
        self.external_access_integrations = external_access_integrations
        self.secrets = secrets
        self.runtime_version = runtime_version

    __properties = ["packages", "imports", "handler", "language", "called_on_null_input", "is_volatile"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PythonFunction(
            packages=self.packages,
            imports=self.imports,
            handler=self.handler,
            external_access_integrations=self.external_access_integrations,
            secrets=self.secrets,
            runtime_version=self.runtime_version,
        )

    @classmethod
    def _from_model(cls, model) -> PythonFunctionModel:
        return PythonFunctionModel(
            packages=model.packages,
            imports=model.imports,
            handler=model.handler,
            external_access_integrations=model.external_access_integrations,
            secrets=model.secrets,
            runtime_version=model.runtime_version,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PythonFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PythonFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PythonFunctionModel:
        """Create an instance of PythonFunction from a dict.

        This method constructs a PythonFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PythonFunction
            A PythonFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PythonFunction.from_dict(obj))


PythonFunction._model_class = PythonFunctionModel
