"""
Snowflake Compute Pools API.

The Snowflake Compute Pools API is a REST API that you can use to access, update, and perform common actions on Compute Pool resources.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional, Union

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr


class ComputePoolInstanceFamily(BaseModel):
    """A model object representing the ComputePoolInstanceFamily resource.

    Constructs an object of type ComputePoolInstanceFamily with the provided properties.

    Parameters
    __________
    name : str, optional
        Name of the instance family.
    description : str, optional
        Description of the instance family.
    vcpu : int, optional
        Number of vCPUs.
    memory_gib : int, optional
        Memory in GiB.
    storage_gib : float, optional
        Storage in GiB.
    gpu : str, optional
        GPU model (if applicable).
    gpu_count : int, optional
        Number of GPUs.
    gpu_memory_gib : int, optional
        GPU memory in GiB (if applicable).
    current_node_usage : int, optional
        Number of nodes currently utilizing this instance family
    message : str, optional
        Additional information about the instance family.
    """

    name: Optional[StrictStr] = None

    description: Optional[StrictStr] = None

    vcpu: Optional[StrictInt] = None

    memory_gib: Optional[StrictInt] = None

    storage_gib: Optional[Union[StrictFloat, StrictInt]] = None

    gpu: Optional[StrictStr] = None

    gpu_count: Optional[StrictInt] = None

    gpu_memory_gib: Optional[StrictInt] = None

    current_node_usage: Optional[StrictInt] = None

    message: Optional[StrictStr] = None

    __properties = [
        "name",
        "description",
        "vcpu",
        "memory_gib",
        "storage_gib",
        "gpu",
        "gpu_count",
        "gpu_memory_gib",
        "current_node_usage",
        "message",
    ]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ComputePoolInstanceFamily:
        """Create an instance of ComputePoolInstanceFamily from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # set to None if gpu (nullable) is None
        if self.gpu is None:
            _dict["gpu"] = None

        # set to None if message (nullable) is None
        if self.message is None:
            _dict["message"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ComputePoolInstanceFamily:
        """Create an instance of ComputePoolInstanceFamily from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ComputePoolInstanceFamily.model_validate(obj)

        _obj = ComputePoolInstanceFamily.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "vcpu": obj.get("vcpu"),
                "memory_gib": obj.get("memory_gib"),
                "storage_gib": obj.get("storage_gib"),
                "gpu": obj.get("gpu"),
                "gpu_count": obj.get("gpu_count"),
                "gpu_memory_gib": obj.get("gpu_memory_gib"),
                "current_node_usage": obj.get("current_node_usage"),
                "message": obj.get("message"),
            }
        )

        return _obj


class ComputePoolInstanceFamilyModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        description: Optional[str] = None,
        vcpu: Optional[int] = None,
        memory_gib: Optional[int] = None,
        storage_gib: Optional[float] = None,
        gpu: Optional[str] = None,
        gpu_count: Optional[int] = None,
        gpu_memory_gib: Optional[int] = None,
        current_node_usage: Optional[int] = None,
        message: Optional[str] = None,
    ):
        """A model object representing the ComputePoolInstanceFamily resource.

        Constructs an object of type ComputePoolInstanceFamily with the provided properties.

        Parameters
        __________
        name : str, optional
            Name of the instance family.
        description : str, optional
            Description of the instance family.
        vcpu : int, optional
            Number of vCPUs.
        memory_gib : int, optional
            Memory in GiB.
        storage_gib : float, optional
            Storage in GiB.
        gpu : str, optional
            GPU model (if applicable).
        gpu_count : int, optional
            Number of GPUs.
        gpu_memory_gib : int, optional
            GPU memory in GiB (if applicable).
        current_node_usage : int, optional
            Number of nodes currently utilizing this instance family
        message : str, optional
            Additional information about the instance family.
        """
        self.name = name
        self.description = description
        self.vcpu = vcpu
        self.memory_gib = memory_gib
        self.storage_gib = storage_gib
        self.gpu = gpu
        self.gpu_count = gpu_count
        self.gpu_memory_gib = gpu_memory_gib
        self.current_node_usage = current_node_usage
        self.message = message

    __properties = [
        "name",
        "description",
        "vcpu",
        "memory_gib",
        "storage_gib",
        "gpu",
        "gpu_count",
        "gpu_memory_gib",
        "current_node_usage",
        "message",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ComputePoolInstanceFamily(
            name=self.name,
            description=self.description,
            vcpu=self.vcpu,
            memory_gib=self.memory_gib,
            storage_gib=self.storage_gib,
            gpu=self.gpu,
            gpu_count=self.gpu_count,
            gpu_memory_gib=self.gpu_memory_gib,
            current_node_usage=self.current_node_usage,
            message=self.message,
        )

    @classmethod
    def _from_model(cls, model) -> ComputePoolInstanceFamilyModel:
        return ComputePoolInstanceFamilyModel(
            name=model.name,
            description=model.description,
            vcpu=model.vcpu,
            memory_gib=model.memory_gib,
            storage_gib=model.storage_gib,
            gpu=model.gpu,
            gpu_count=model.gpu_count,
            gpu_memory_gib=model.gpu_memory_gib,
            current_node_usage=model.current_node_usage,
            message=model.message,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ComputePoolInstanceFamily.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ComputePoolInstanceFamily object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ComputePoolInstanceFamilyModel:
        """Create an instance of ComputePoolInstanceFamily from a dict.

        This method constructs a ComputePoolInstanceFamily object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ComputePoolInstanceFamily
            A ComputePoolInstanceFamily object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ComputePoolInstanceFamily.from_dict(obj))


ComputePoolInstanceFamily._model_class = ComputePoolInstanceFamilyModel
