"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class CreateAnalystEvalOptimizationRequest(BaseModel):
    """A model object representing the CreateAnalystEvalOptimizationRequest resource.

    Constructs an object of type CreateAnalystEvalOptimizationRequest with the provided properties.

    Parameters
    __________
    semantic_view : str
        Fully qualified name of the semantic view for the eval.
    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    semantic_view: StrictStr

    experimental: Optional[StrictStr] = None

    __properties = ["semantic_view", "experimental"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateAnalystEvalOptimizationRequest:
        """Create an instance of CreateAnalystEvalOptimizationRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAnalystEvalOptimizationRequest:
        """Create an instance of CreateAnalystEvalOptimizationRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateAnalystEvalOptimizationRequest.model_validate(obj)

        _obj = CreateAnalystEvalOptimizationRequest.model_validate(
            {
                "semantic_view": obj.get("semantic_view"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class CreateAnalystEvalOptimizationRequestModel:
    def __init__(
        self,
        semantic_view: str,
        # optional properties
        experimental: Optional[str] = None,
    ):
        """A model object representing the CreateAnalystEvalOptimizationRequest resource.

        Constructs an object of type CreateAnalystEvalOptimizationRequest with the provided properties.

        Parameters
        __________
        semantic_view : str
            Fully qualified name of the semantic view for the eval.
        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.semantic_view = semantic_view
        self.experimental = experimental

    __properties = ["semantic_view", "experimental"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CreateAnalystEvalOptimizationRequest(
            semantic_view=self.semantic_view,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> CreateAnalystEvalOptimizationRequestModel:
        return CreateAnalystEvalOptimizationRequestModel(
            semantic_view=model.semantic_view,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CreateAnalystEvalOptimizationRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CreateAnalystEvalOptimizationRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAnalystEvalOptimizationRequestModel:
        """Create an instance of CreateAnalystEvalOptimizationRequest from a dict.

        This method constructs a CreateAnalystEvalOptimizationRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CreateAnalystEvalOptimizationRequest
            A CreateAnalystEvalOptimizationRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CreateAnalystEvalOptimizationRequest.from_dict(obj))


CreateAnalystEvalOptimizationRequest._model_class = CreateAnalystEvalOptimizationRequestModel
