"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.verified_query_suggestion import (
    VerifiedQuerySuggestion,
    VerifiedQuerySuggestionModel,
)
from snowflake.core.cortex.analyst_service._generated.models.warning import Warning, WarningModel


class GenerateVerifiedQuerySuggestionsResponse(BaseModel):
    """A model object representing the GenerateVerifiedQuerySuggestionsResponse resource.

    Constructs an object of type GenerateVerifiedQuerySuggestionsResponse with the provided properties.

    Parameters
    __________
    request_id : str, optional
        Unique request ID
    vq_suggestions : list[VerifiedQuerySuggestion], optional

    warnings : list[Warning], optional
    """

    request_id: Optional[StrictStr] = None

    vq_suggestions: Optional[List[VerifiedQuerySuggestion]] = None

    warnings: Optional[List[Warning]] = None

    __properties = ["request_id", "vq_suggestions", "warnings"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GenerateVerifiedQuerySuggestionsResponse:
        """Create an instance of GenerateVerifiedQuerySuggestionsResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in vq_suggestions (list)
        _items = []
        if self.vq_suggestions:
            for _item in self.vq_suggestions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["vq_suggestions"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict["warnings"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateVerifiedQuerySuggestionsResponse:
        """Create an instance of GenerateVerifiedQuerySuggestionsResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GenerateVerifiedQuerySuggestionsResponse.model_validate(obj)

        _obj = GenerateVerifiedQuerySuggestionsResponse.model_validate(
            {
                "request_id": obj.get("request_id"),
                "vq_suggestions": [VerifiedQuerySuggestion.from_dict(_item) for _item in obj.get("vq_suggestions")]
                if obj.get("vq_suggestions") is not None
                else None,
                "warnings": [Warning.from_dict(_item) for _item in obj.get("warnings")]
                if obj.get("warnings") is not None
                else None,
            }
        )

        return _obj


class GenerateVerifiedQuerySuggestionsResponseModel:
    def __init__(
        self,  # optional properties
        request_id: Optional[str] = None,
        vq_suggestions: Optional[list[VerifiedQuerySuggestion]] = None,
        warnings: Optional[list[Warning]] = None,
    ):
        """A model object representing the GenerateVerifiedQuerySuggestionsResponse resource.

        Constructs an object of type GenerateVerifiedQuerySuggestionsResponse with the provided properties.

        Parameters
        __________
        request_id : str, optional
            Unique request ID
        vq_suggestions : list[VerifiedQuerySuggestion], optional

        warnings : list[Warning], optional
        """
        self.request_id = request_id
        self.vq_suggestions = vq_suggestions
        self.warnings = warnings

    __properties = ["request_id", "vq_suggestions", "warnings"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GenerateVerifiedQuerySuggestionsResponse(
            request_id=self.request_id,
            vq_suggestions=[x._to_model() for x in self.vq_suggestions] if self.vq_suggestions is not None else None,
            warnings=[x._to_model() for x in self.warnings] if self.warnings is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> GenerateVerifiedQuerySuggestionsResponseModel:
        return GenerateVerifiedQuerySuggestionsResponseModel(
            request_id=model.request_id,
            vq_suggestions=[VerifiedQuerySuggestionModel._from_model(x) for x in model.vq_suggestions]
            if model.vq_suggestions
            else None,
            warnings=[WarningModel._from_model(x) for x in model.warnings] if model.warnings else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GenerateVerifiedQuerySuggestionsResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GenerateVerifiedQuerySuggestionsResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateVerifiedQuerySuggestionsResponseModel:
        """Create an instance of GenerateVerifiedQuerySuggestionsResponse from a dict.

        This method constructs a GenerateVerifiedQuerySuggestionsResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GenerateVerifiedQuerySuggestionsResponse
            A GenerateVerifiedQuerySuggestionsResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GenerateVerifiedQuerySuggestionsResponse.from_dict(obj))


GenerateVerifiedQuerySuggestionsResponse._model_class = GenerateVerifiedQuerySuggestionsResponseModel
