"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import ConfigDict, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.message_content import MessageContent


class MessageContentChartObject(MessageContent):
    """A model object representing the MessageContentChartObject resource.

    Constructs an object of type MessageContentChartObject with the provided properties.

    Parameters
    __________
    chart_spec : str
    """

    chart_spec: StrictStr

    __properties = ["type", "chart_spec"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentChartObject:
        """Create an instance of MessageContentChartObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["type"] = MessageContent.get_child_model_discriminator_value("MessageContentChartObject")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentChartObject:
        """Create an instance of MessageContentChartObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentChartObject.model_validate(obj)

        _obj = MessageContentChartObject.model_validate(
            {
                "chart_spec": obj.get("chart_spec"),
            }
        )

        return _obj


class MessageContentChartObjectModel(MessageContent):
    def __init__(
        self,
        chart_spec: str,
        # optional properties
    ):
        """A model object representing the MessageContentChartObject resource.

        Constructs an object of type MessageContentChartObject with the provided properties.

        Parameters
        __________
        chart_spec : str
        """
        super().__init__()
        self.chart_spec = chart_spec

    __properties = ["type", "chart_spec"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentChartObject(
            chart_spec=self.chart_spec,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentChartObjectModel:
        return MessageContentChartObjectModel(
            chart_spec=model.chart_spec,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentChartObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentChartObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentChartObjectModel:
        """Create an instance of MessageContentChartObject from a dict.

        This method constructs a MessageContentChartObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentChartObject
            A MessageContentChartObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentChartObject.from_dict(obj))


MessageContentChartObject._model_class = MessageContentChartObjectModel
