"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr, field_validator

from snowflake.core.cortex.analyst_service._generated.models.message_object import MessageObject, MessageObjectModel
from snowflake.core.cortex.analyst_service._generated.models.semantic_model_object import (
    SemanticModelObject,
    SemanticModelObjectModel,
)


class SendMessageRequest(BaseModel):
    """A model object representing the SendMessageRequest resource.

    Constructs an object of type SendMessageRequest with the provided properties.

    Parameters
    __________
    messages : list[MessageObject]

    semantic_model_file : str, optional
        The path to a file stored in a Snowflake Stage holding the semantic model yaml. Must be a fully qualified stage url
    semantic_model : str, optional
        A string containing the entire semantic model yaml
    semantic_view : str, optional
        The name of the Snowflake native semantic model object
    semantic_models : list[SemanticModelObject], optional
        A list of semantic model objects. If set, other semantic model properties are ignored
    stream : bool,  default False
        Whether to stream the response or not
    operation : str,  default 'sql_generation'
        Whether to response with SQL or natural language. One of 'sql_generation' or 'answer_generation'
    warehouse : str, optional
        Warehouse name to use for result set handling. Only used when 'operation' is 'answer_generation'
    source : str, optional
        an optional field to specify the source of the request. e.g "eval", "prod"
    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    semantic_model_file: Optional[StrictStr] = None

    semantic_model: Optional[StrictStr] = None

    semantic_view: Optional[StrictStr] = None

    semantic_models: Optional[List[SemanticModelObject]] = None

    stream: Optional[StrictBool] = False

    operation: Optional[StrictStr] = "sql_generation"

    warehouse: Optional[StrictStr] = None

    messages: List[MessageObject]

    source: Optional[StrictStr] = None

    experimental: Optional[StrictStr] = None

    __properties = [
        "semantic_model_file",
        "semantic_model",
        "semantic_view",
        "semantic_models",
        "stream",
        "operation",
        "warehouse",
        "messages",
        "source",
        "experimental",
    ]

    @field_validator("operation")
    def operation_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("sql_generation", "answer_generation"):
            raise ValueError("must validate the enum values ('sql_generation','answer_generation')")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SendMessageRequest:
        """Create an instance of SendMessageRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in semantic_models (list)
        _items = []
        if self.semantic_models:
            for _item in self.semantic_models:
                if _item:
                    _items.append(_item.to_dict())
            _dict["semantic_models"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict["messages"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SendMessageRequest:
        """Create an instance of SendMessageRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SendMessageRequest.model_validate(obj)

        _obj = SendMessageRequest.model_validate(
            {
                "semantic_model_file": obj.get("semantic_model_file"),
                "semantic_model": obj.get("semantic_model"),
                "semantic_view": obj.get("semantic_view"),
                "semantic_models": [SemanticModelObject.from_dict(_item) for _item in obj.get("semantic_models")]
                if obj.get("semantic_models") is not None
                else None,
                "stream": obj.get("stream") if obj.get("stream") is not None else False,
                "operation": obj.get("operation") if obj.get("operation") is not None else "sql_generation",
                "warehouse": obj.get("warehouse"),
                "messages": [MessageObject.from_dict(_item) for _item in obj.get("messages")]
                if obj.get("messages") is not None
                else None,
                "source": obj.get("source"),
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class SendMessageRequestModel:
    def __init__(
        self,
        messages: list[MessageObject],
        # optional properties
        semantic_model_file: Optional[str] = None,
        semantic_model: Optional[str] = None,
        semantic_view: Optional[str] = None,
        semantic_models: Optional[list[SemanticModelObject]] = None,
        stream: Optional[bool] = False,
        operation: Optional[str] = "sql_generation",
        warehouse: Optional[str] = None,
        source: Optional[str] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the SendMessageRequest resource.

        Constructs an object of type SendMessageRequest with the provided properties.

        Parameters
        __________
        messages : list[MessageObject]

        semantic_model_file : str, optional
            The path to a file stored in a Snowflake Stage holding the semantic model yaml. Must be a fully qualified stage url
        semantic_model : str, optional
            A string containing the entire semantic model yaml
        semantic_view : str, optional
            The name of the Snowflake native semantic model object
        semantic_models : list[SemanticModelObject], optional
            A list of semantic model objects. If set, other semantic model properties are ignored
        stream : bool,  default False
            Whether to stream the response or not
        operation : str,  default 'sql_generation'
            Whether to response with SQL or natural language. One of 'sql_generation' or 'answer_generation'
        warehouse : str, optional
            Warehouse name to use for result set handling. Only used when 'operation' is 'answer_generation'
        source : str, optional
            an optional field to specify the source of the request. e.g "eval", "prod"
        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.semantic_model_file = semantic_model_file
        self.semantic_model = semantic_model
        self.semantic_view = semantic_view
        self.semantic_models = semantic_models
        self.stream = stream
        self.operation = operation
        self.warehouse = warehouse
        self.messages = messages
        self.source = source
        self.experimental = experimental

    __properties = [
        "semantic_model_file",
        "semantic_model",
        "semantic_view",
        "semantic_models",
        "stream",
        "operation",
        "warehouse",
        "messages",
        "source",
        "experimental",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SendMessageRequest(
            semantic_model_file=self.semantic_model_file,
            semantic_model=self.semantic_model,
            semantic_view=self.semantic_view,
            semantic_models=[x._to_model() for x in self.semantic_models] if self.semantic_models is not None else None,
            stream=self.stream,
            operation=self.operation,
            warehouse=self.warehouse,
            messages=[x._to_model() for x in self.messages] if self.messages is not None else None,
            source=self.source,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> SendMessageRequestModel:
        return SendMessageRequestModel(
            semantic_model_file=model.semantic_model_file,
            semantic_model=model.semantic_model,
            semantic_view=model.semantic_view,
            semantic_models=[SemanticModelObjectModel._from_model(x) for x in model.semantic_models]
            if model.semantic_models
            else None,
            stream=model.stream,
            operation=model.operation,
            warehouse=model.warehouse,
            messages=[MessageObjectModel._from_model(x) for x in model.messages] if model.messages else None,
            source=model.source,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SendMessageRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SendMessageRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SendMessageRequestModel:
        """Create an instance of SendMessageRequest from a dict.

        This method constructs a SendMessageRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SendMessageRequest
            A SendMessageRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SendMessageRequest.from_dict(obj))


SendMessageRequest._model_class = SendMessageRequestModel
