"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class StatusUpdate(BaseModel):
    """A model object representing the StatusUpdate resource.

    Constructs an object of type StatusUpdate with the provided properties.

    Parameters
    __________
    status : str
        The latest status for processing the request
    status_message : str, optional
        A human readable description on the current request processing status
    request_id : str, optional
        Unique request ID.
    """

    status: StrictStr

    status_message: Optional[StrictStr] = None

    request_id: Optional[StrictStr] = None

    __properties = ["status", "status_message", "request_id"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StatusUpdate:
        """Create an instance of StatusUpdate from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StatusUpdate:
        """Create an instance of StatusUpdate from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StatusUpdate.model_validate(obj)

        _obj = StatusUpdate.model_validate(
            {
                "status": obj.get("status"),
                "status_message": obj.get("status_message"),
                "request_id": obj.get("request_id"),
            }
        )

        return _obj


class StatusUpdateModel:
    def __init__(
        self,
        status: str,
        # optional properties
        status_message: Optional[str] = None,
        request_id: Optional[str] = None,
    ):
        """A model object representing the StatusUpdate resource.

        Constructs an object of type StatusUpdate with the provided properties.

        Parameters
        __________
        status : str
            The latest status for processing the request
        status_message : str, optional
            A human readable description on the current request processing status
        request_id : str, optional
            Unique request ID.
        """
        self.status = status
        self.status_message = status_message
        self.request_id = request_id

    __properties = ["status", "status_message", "request_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StatusUpdate(
            status=self.status,
            status_message=self.status_message,
            request_id=self.request_id,
        )

    @classmethod
    def _from_model(cls, model) -> StatusUpdateModel:
        return StatusUpdateModel(
            status=model.status,
            status_message=model.status_message,
            request_id=model.request_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StatusUpdate.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StatusUpdate object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StatusUpdateModel:
        """Create an instance of StatusUpdate from a dict.

        This method constructs a StatusUpdate object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StatusUpdate
            A StatusUpdate object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StatusUpdate.from_dict(obj))


StatusUpdate._model_class = StatusUpdateModel
