"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictInt


class AgentOrchestrationBudget(BaseModel):
    """A model object representing the AgentOrchestrationBudget resource.

    Constructs an object of type AgentOrchestrationBudget with the provided properties.

    Parameters
    __________
    seconds : int, optional
        Time budget in seconds.
    tokens : int, optional
        Token budget.
    """

    seconds: Optional[StrictInt] = None

    tokens: Optional[StrictInt] = None

    __properties = ["seconds", "tokens"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgentOrchestrationBudget:
        """Create an instance of AgentOrchestrationBudget from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgentOrchestrationBudget:
        """Create an instance of AgentOrchestrationBudget from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AgentOrchestrationBudget.model_validate(obj)

        _obj = AgentOrchestrationBudget.model_validate(
            {
                "seconds": obj.get("seconds"),
                "tokens": obj.get("tokens"),
            }
        )

        return _obj


class AgentOrchestrationBudgetModel:
    def __init__(
        self,  # optional properties
        seconds: Optional[int] = None,
        tokens: Optional[int] = None,
    ):
        """A model object representing the AgentOrchestrationBudget resource.

        Constructs an object of type AgentOrchestrationBudget with the provided properties.

        Parameters
        __________
        seconds : int, optional
            Time budget in seconds.

        tokens : int, optional
            Token budget.
        """
        self.seconds = seconds
        self.tokens = tokens

    __properties = ["seconds", "tokens"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgentOrchestrationBudget(
            seconds=self.seconds,
            tokens=self.tokens,
        )

    @classmethod
    def _from_model(cls, model) -> AgentOrchestrationBudgetModel:
        return AgentOrchestrationBudgetModel(
            seconds=model.seconds,
            tokens=model.tokens,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AgentOrchestrationBudget.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgentOrchestrationBudget object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgentOrchestrationBudgetModel:
        """Create an instance of AgentOrchestrationBudget from a dict.

        This method constructs a AgentOrchestrationBudget object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgentOrchestrationBudget
            A AgentOrchestrationBudget object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgentOrchestrationBudget.from_dict(obj))


AgentOrchestrationBudget._model_class = AgentOrchestrationBudgetModel
