"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict

from snowflake.core.cortex.lite_agent_service._generated.models.mcp_server_spec import McpServerSpec, McpServerSpecModel


class McpServerWrapper(BaseModel):
    """A model object representing the McpServerWrapper resource.

    Constructs an object of type McpServerWrapper with the provided properties.

    Parameters
    __________
    server_spec : McpServerSpec, optional
    """

    server_spec: Optional[McpServerSpec] = None

    __properties = ["server_spec"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> McpServerWrapper:
        """Create an instance of McpServerWrapper from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of server_spec
        if self.server_spec:
            _dict["server_spec"] = self.server_spec.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> McpServerWrapper:
        """Create an instance of McpServerWrapper from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return McpServerWrapper.model_validate(obj)

        _obj = McpServerWrapper.model_validate(
            {
                "server_spec": McpServerSpec.from_dict(obj.get("server_spec"))
                if obj.get("server_spec") is not None
                else None,
            }
        )

        return _obj


class McpServerWrapperModel:
    def __init__(
        self,  # optional properties
        server_spec: Optional[McpServerSpec] = None,
    ):
        """A model object representing the McpServerWrapper resource.

        Constructs an object of type McpServerWrapper with the provided properties.

        Parameters
        __________
        server_spec : McpServerSpec, optional
        """
        self.server_spec = server_spec

    __properties = ["server_spec"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return McpServerWrapper(
            server_spec=self.server_spec._to_model() if self.server_spec is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> McpServerWrapperModel:
        return McpServerWrapperModel(
            server_spec=McpServerSpecModel._from_model(model.server_spec) if model.server_spec else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a McpServerWrapper.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the McpServerWrapper object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> McpServerWrapperModel:
        """Create an instance of McpServerWrapper from a dict.

        This method constructs a McpServerWrapper object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        McpServerWrapper
            A McpServerWrapper object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(McpServerWrapper.from_dict(obj))


McpServerWrapper._model_class = McpServerWrapperModel
