"""
Snowflake Function API.

The Snowflake Function API is a REST API that allows caller to create, execute and drop functions in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from typing import TYPE_CHECKING, Iterator, List, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.function._generated.models.function import Function
from snowflake.core.function._generated.models.function_argument import FunctionArgument
from snowflake.core.function._generated.models.tag_assignment import TagAssignment
from snowflake.core.function._generated.models.tag_reference import TagReference
from snowflake.core.tag import TagResource, TagValue

from .function_api import FunctionApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class FunctionCollectionBase(SchemaObjectCollectionParent["FunctionResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = FunctionApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(self, function: Function, mode: Optional[Union[CreateMode, str]] = None) -> "FunctionResource":  # noqa: F821
        """Create a Function.

        Parameters
        __________
        function: Function
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_function(
            self.database.name,
            self.schema.name,
            function=function,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(function), self)
        return self._ref_class(function.name, self)

    @api_telemetry
    def create_async(
        self, function: Function, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["FunctionResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_function(
            self.database.name,
            self.schema.name,
            function=function,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(future, lambda _: self._ref_class(get_function_name_with_args(function), self))
        return PollingOperation(
            future, lambda _: self._ref_class(function if isinstance(function, str) else function.name, self)
        )

    @api_telemetry
    def iter(self, *, like: Optional[str] = None) -> Iterator[Function]:
        """List Functions.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        """
        resources = self._api.list_functions(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(self, *, like: Optional[str] = None) -> PollingOperation[Iterator[Function]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self._api.list_functions(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class FunctionResourceBase(SchemaObjectReferenceMixin["FunctionCollection"]):
    _collection_class: FunctionCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: FunctionCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def execute(
        self,
        function_argument: Optional[List[FunctionArgument]] = None,
    ) -> object:
        """Execute a Function.

        Parameters
        __________
        function_argument: List[FunctionArgument]
        """
        result = self.collection._api.execute_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            function_argument=function_argument,
            async_req=False,
        )
        return result

    @api_telemetry
    def execute_async(
        self,
        function_argument: Optional[List[FunctionArgument]] = None,
    ) -> PollingOperation[object]:
        """An asynchronous version of :func:`execute`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.execute_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            function_argument=function_argument,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def fetch(
        self,
    ) -> Function:
        """Fetch a Function.

        Parameters
        __________
        """
        result = self.collection._api.fetch_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )
        return result

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[Function]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def get_tags(
        self,
        with_lineage: Optional[bool] = None,
    ) -> dict[TagResource, TagValue]:
        """Get the tag assignments for a function.

        Returns all tags assigned to a function. This operation requires an active warehouse.

        Parameters
        __________
        with_lineage: bool
             Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        """
        result = self.collection._api.get_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            with_lineage=with_lineage,
            async_req=False,
        )
        result = dict(self._to_get_tags_tuple(tag_assignment) for tag_assignment in result)
        return result

    @api_telemetry
    def get_tags_async(
        self,
        with_lineage: Optional[bool] = None,
    ) -> PollingOperation[dict[TagResource, TagValue]]:
        """An asynchronous version of :func:`get_tags`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.get_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            with_lineage=with_lineage,
            async_req=True,
        )
        return PollingOperation(
            future, lambda tag_assignments: dict(self._to_get_tags_tuple(ta) for ta in tag_assignments)
        )

    def _to_get_tags_tuple(self, ta: TagAssignment) -> tuple[TagResource, TagValue]:
        db = ta.tag_database
        schema = ta.tag_schema

        if db is None:
            raise ValueError("TagAssignment must have tag_database set.")

        if schema is None:
            raise ValueError("TagAssignment must have tag_schema set.")

        tag_resource = self.root.databases[db].schemas[schema].tags[ta.tag_name]
        tag_value = TagValue(ta.tag_value, ta.level)
        return tag_resource, tag_value

    @api_telemetry
    def set_tags(
        self,
        tags: dict[TagResource, TagValue],
        if_exists: Optional[bool] = None,
    ) -> None:
        """Set tags on a function.

        Parameters
        __________
        tags: dict[TagResource, TagValue]
             (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        tag_assignment = [
            self._to_tag_assignment(tag_resource, tag_value) for [tag_resource, tag_value] in tags.items()
        ]
        self.collection._api.set_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_assignment=tag_assignment,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def set_tags_async(
        self,
        tags: dict[TagResource, TagValue],
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`set_tags`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        tag_assignment = [
            self._to_tag_assignment(tag_resource, tag_value) for [tag_resource, tag_value] in tags.items()
        ]
        future = self.collection._api.set_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_assignment=tag_assignment,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @staticmethod
    def _to_tag_assignment(tag_resource: TagResource, tag_value: TagValue) -> TagAssignment:
        return TagAssignment(
            tag_name=tag_resource.name,
            tag_schema=tag_resource.schema.name,
            tag_database=tag_resource.database.name,
            tag_value=tag_value.value,
        )

    @api_telemetry
    def unset_tags(
        self,
        tag_resources: set[TagResource],
        if_exists: Optional[bool] = None,
    ) -> None:
        """Unset tags from a function.

        Parameters
        __________
        tag_resources: set[TagResource]
             (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        tag_reference = [self._to_tag_reference(tag_resource) for tag_resource in tag_resources]
        self.collection._api.unset_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_reference=tag_reference,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def unset_tags_async(
        self,
        tag_resources: set[TagResource],
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`unset_tags`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        tag_reference = [self._to_tag_reference(tag_resource) for tag_resource in tag_resources]
        future = self.collection._api.unset_tags(
            self.database.name,
            self.schema.name,
            self._identifier,
            tag_reference=tag_reference,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @staticmethod
    def _to_tag_reference(resource: TagResource) -> TagReference:
        return TagReference(
            tag_name=resource.name,
            tag_schema=resource.schema.name,
            tag_database=resource.database.name,
        )

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a function.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_function(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
