"""
Snowflake Role API.

The Snowflake Role API is a REST API that you can use to access, update, and perform certain actions on Role resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import json
import logging
import os
import re
import tempfile

from concurrent.futures import Future
from datetime import date, datetime
from typing import Iterable, List, Literal, Optional, Union, overload

from dateutil.parser import parse
from pydantic import Field, StrictBool, StrictStr, validate_call
from typing_extensions import Annotated

import snowflake.core._http_requests

from snowflake.core._generated import rest
from snowflake.core._generated.api_client import ApiClient
from snowflake.core._internal.utils import is_running_inside_stored_procedure
from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError,
    _APIValueError,
)
from snowflake.core.role._generated import models
from snowflake.core.role._generated.models.grant import Grant
from snowflake.core.role._generated.models.grant_of import GrantOf
from snowflake.core.role._generated.models.grant_on import GrantOn
from snowflake.core.role._generated.models.role import Role
from snowflake.core.role._generated.models.success_response import SuccessResponse
from snowflake.core.role._generated.models.tag_assignment import TagAssignment
from snowflake.core.role._generated.models.tag_reference import TagReference


logger = logging.getLogger(__name__)


class RoleApi:
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = "role"
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default()

    @property
    def api_client(self):
        return self._api_client

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if isinstance(klass, str):
            if klass.startswith("Iterable["):
                sub_kls = re.match(r"Iterable\[(.*)]", klass).group(1)
                return [self.__deserialize(sub_data, sub_kls) for sub_data in data]

            if klass.startswith("Dict["):
                sub_kls = re.match(r"Dict\[([^,]*), (.*)]", klass).group(2)
                return {k: self.__deserialize(v, sub_kls) for k, v in data.items()}

            # convert str to class
            if klass in snowflake.core._http_requests.NATIVE_TYPES_MAPPING:
                klass = snowflake.core._http_requests.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(models, klass)

        if klass in snowflake.core._http_requests.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:  # noqa: E721
            return self.__deserialize_object(data)
        elif klass == date:
            return self.__deserialize_date(data)
        elif klass == datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def __deserialize_file(self, response):
        """Deserializes body to file.

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.api_client.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?', content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=f"Failed to parse `{string}` as date object")

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.APIError(status=0, reason=(f"Failed to parse `{string}` as datetime object"))

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """
        return klass.from_dict(data)

    @overload
    def create_role(
        self,
        role: Role,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def create_role(
        self,
        role: Role,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def create_role(
        self,
        role: Role,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def create_role(
        self,
        role: Role,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Create a role  # noqa: E501

        Create a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_role(role, create_mode, async_req=True)
        >>> result = future.result()
        :param role: (required)
        :type role: Role
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.create_role_with_http_info(role, create_mode, **kwargs)

    @validate_call
    def create_role_with_http_info(
        self,
        role: Role,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Create a role  # noqa: E501

        Create a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_role_with_http_info(role, create_mode, async_req=True)
        >>> result = future.result()
        :param role: (required)
        :type role: Role
        :param create_mode: Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["role", "create_mode"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method create_role")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get("create_mode") is not None:
            _query_params.append(("createMode", _params["create_mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["role"] is not None:
            _body_params = _params["role"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[TagAssignment]: ...

    @overload
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[TagAssignment]]: ...

    @overload
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]: ...

    @validate_call
    def get_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]:
        r"""Get the tag assignments for a role.  # noqa: E501

        Returns all tags assigned to a role. This operation requires an active warehouse.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_tags(name, with_lineage, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param with_lineage: Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        :type with_lineage: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.get_tags_with_http_info(name, with_lineage, **kwargs)

    @validate_call
    def get_tags_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        with_lineage: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Get the tag assignments for a role.  # noqa: E501

        Returns all tags assigned to a role. This operation requires an active warehouse.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_tags_with_http_info(name, with_lineage, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param with_lineage: Parameter that specifies whether tag assignments inherited by the object from its ancestors in securable object hierarchy should be returned as well: - `true`: All tags assigned to this object should be returned, inheritance included. - `false`: Only tags explicitly assigned to this object should be returned.
        :type with_lineage: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[TagAssignment], Future[Iterable[TagAssignment]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "with_lineage"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method get_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("with_lineage") is not None:
            _query_params.append(("withLineage", _params["with_lineage"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[TagAssignment]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}:get-tags",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def grant_future_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def grant_future_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def grant_future_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def grant_future_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Grant future privileges to the role  # noqa: E501

        Grant future privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_future_privileges(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.grant_future_privileges_with_http_info(name, grant, **kwargs)

    @validate_call
    def grant_future_privileges_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        **kwargs,
    ):
        r"""Grant future privileges to the role  # noqa: E501

        Grant future privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_future_privileges_with_http_info(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "grant"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method grant_future_privileges")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["grant"] is not None:
            _body_params = _params["grant"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/future-grants",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def grant_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def grant_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def grant_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def grant_privileges(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Grant privileges to the role  # noqa: E501

        Grant privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_privileges(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.grant_privileges_with_http_info(name, grant, **kwargs)

    @validate_call
    def grant_privileges_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        **kwargs,
    ):
        r"""Grant privileges to the role  # noqa: E501

        Grant privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_privileges_with_http_info(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "grant"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method grant_privileges")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["grant"] is not None:
            _body_params = _params["grant"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/grants",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[Grant]: ...

    @overload
    def list_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[Grant]]: ...

    @overload
    def list_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]: ...

    @validate_call
    def list_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:
        r"""List all future grants to the role  # noqa: E501

        List all future grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_future_grants(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Grant], Future[Iterable[Grant]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_future_grants_with_http_info(name, show_limit, **kwargs)

    @validate_call
    def list_future_grants_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ):
        r"""List all future grants to the role  # noqa: E501

        List all future grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_future_grants_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Grant], Future[Iterable[Grant]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "show_limit"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_future_grants")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[Grant]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/future-grants",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[Grant]: ...

    @overload
    def list_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[Grant]]: ...

    @overload
    def list_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]: ...

    @validate_call
    def list_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:
        r"""List all grants to the role  # noqa: E501

        List all grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Grant], Future[Iterable[Grant]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_grants_with_http_info(name, show_limit, **kwargs)

    @validate_call
    def list_grants_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ):
        r"""List all grants to the role  # noqa: E501

        List all grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Grant], Future[Iterable[Grant]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "show_limit"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_grants")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[Grant]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/grants",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_grants_of(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[GrantOf]: ...

    @overload
    def list_grants_of(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[GrantOf]]: ...

    @overload
    def list_grants_of(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]: ...

    @validate_call
    def list_grants_of(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]:
        r"""List all grants of the role  # noqa: E501

        List all grants of the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_of(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_grants_of_with_http_info(name, show_limit, **kwargs)

    @validate_call
    def list_grants_of_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ):
        r"""List all grants of the role  # noqa: E501

        List all grants of the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_of_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[GrantOf], Future[Iterable[GrantOf]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "show_limit"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_grants_of")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[GrantOf]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/grants-of",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_grants_on(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[GrantOn]: ...

    @overload
    def list_grants_on(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[GrantOn]]: ...

    @overload
    def list_grants_on(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[GrantOn], Future[Iterable[GrantOn]]]: ...

    @validate_call
    def list_grants_on(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[GrantOn], Future[Iterable[GrantOn]]]:
        r"""List all grants on the role  # noqa: E501

        List all grants on the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_on(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[GrantOn], Future[Iterable[GrantOn]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_grants_on_with_http_info(name, show_limit, **kwargs)

    @validate_call
    def list_grants_on_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        **kwargs,
    ):
        r"""List all grants on the role  # noqa: E501

        List all grants on the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_on_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[GrantOn], Future[Iterable[GrantOn]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "show_limit"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_grants_on")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[GrantOn]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/grants-on",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def list_roles(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> Iterable[Role]: ...

    @overload
    def list_roles(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[Iterable[Role]]: ...

    @overload
    def list_roles(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[Iterable[Role], Future[Iterable[Role]]]: ...

    @validate_call
    def list_roles(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        **kwargs,
    ) -> Union[Iterable[Role], Future[Iterable[Role]]]:
        r"""List roles  # noqa: E501

        List roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_roles(like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Role], Future[Iterable[Role]]]
        """
        kwargs["_return_http_data_only"] = True
        return self.list_roles_with_http_info(like, starts_with, show_limit, from_name, **kwargs)

    @validate_call
    def list_roles_with_http_info(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            ),
        ] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            ),
        ] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(description="Parameter to limit the maximum number of rows returned by a command."),
        ] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            ),
        ] = None,
        **kwargs,
    ):
        r"""List roles  # noqa: E501

        List roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_roles_with_http_info(like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param like: Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Role], Future[Iterable[Role]]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["like", "starts_with", "show_limit", "from_name"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method list_roles")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get("like") is not None:
            _query_params.append(("like", _params["like"]))

        if _params.get("starts_with") is not None:
            _query_params.append(("startsWith", _params["starts_with"]))

        if _params.get("show_limit") is not None:
            _query_params.append(("showLimit", _params["show_limit"]))

        if _params.get("from_name") is not None:
            _query_params.append(("fromName", _params["from_name"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "Iterable[Role]",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def revoke_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def revoke_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def revoke_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def revoke_future_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Revoke future grants from the role  # noqa: E501

        Revoke future grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_future_grants(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.revoke_future_grants_with_http_info(name, grant, mode, **kwargs)

    @validate_call
    def revoke_future_grants_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Revoke future grants from the role  # noqa: E501

        Revoke future grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_future_grants_with_http_info(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "grant", "mode"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method revoke_future_grants")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("mode") is not None:
            _query_params.append(("mode", _params["mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["grant"] is not None:
            _body_params = _params["grant"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/future-grants:revoke",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def revoke_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def revoke_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def revoke_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def revoke_grants(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Revoke grants from the role  # noqa: E501

        Revoke grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_grants(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.revoke_grants_with_http_info(name, grant, mode, **kwargs)

    @validate_call
    def revoke_grants_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description="Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Revoke grants from the role  # noqa: E501

        Revoke grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_grants_with_http_info(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "grant", "mode"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method revoke_grants")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("mode") is not None:
            _query_params.append(("mode", _params["mode"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["grant"] is not None:
            _body_params = _params["grant"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}/grants:revoke",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def set_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Set tags on a role.  # noqa: E501

        Set tags on a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_tags(name, tag_assignment, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_assignment: (required)
        :type tag_assignment: List[TagAssignment]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.set_tags_with_http_info(name, tag_assignment, if_exists, **kwargs)

    @validate_call
    def set_tags_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_assignment: List[TagAssignment],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Set tags on a role.  # noqa: E501

        Set tags on a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.set_tags_with_http_info(name, tag_assignment, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_assignment: (required)
        :type tag_assignment: List[TagAssignment]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "tag_assignment", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method set_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["tag_assignment"] is not None:
            _body_params = _params["tag_assignment"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}:set-tags",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def unset_tags(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Unset tags from a role.  # noqa: E501

        Unset tags from a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.unset_tags(name, tag_reference, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_reference: (required)
        :type tag_reference: List[TagReference]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.unset_tags_with_http_info(name, tag_reference, if_exists, **kwargs)

    @validate_call
    def unset_tags_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        tag_reference: List[TagReference],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Unset tags from a role.  # noqa: E501

        Unset tags from a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.unset_tags_with_http_info(name, tag_reference, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param tag_reference: (required)
        :type tag_reference: List[TagReference]
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "tag_reference", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method unset_tags")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params["tag_reference"] is not None:
            _body_params = _params["tag_reference"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}:unset-tags",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )

    @overload
    def delete_role(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[False] = False,
        **kwargs,
    ) -> SuccessResponse: ...

    @overload
    def delete_role(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: Literal[True] = True,
        **kwargs,
    ) -> Future[SuccessResponse]: ...

    @overload
    def delete_role(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        async_req: bool = False,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]: ...

    @validate_call
    def delete_role(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:
        r"""Delete a role  # noqa: E501

        Delete a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_role(name, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_role_with_http_info(name, if_exists, **kwargs)

    @validate_call
    def delete_role_with_http_info(
        self,
        name: Annotated[str, Field(strict=True, description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description="Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            ),
        ] = None,
        **kwargs,
    ):
        r"""Delete a role  # noqa: E501

        Delete a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_role_with_http_info(name, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """
        _params = locals()

        _all_params = ["name", "if_exists"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise _APITypeError(f"Got an unexpected keyword argument '{_key}' to method delete_role")
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params["name"]:
            _path_params["name"] = _params["name"]

        # process the query parameters
        _query_params = []

        if _params.get("if_exists") is not None:
            _query_params.append(("ifExists", _params["if_exists"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # authentication setting
        _auth_settings = ["ExternalOAuth", "KeyPair", "ProgrammaticAccessToken", "SnowflakeOAuth"]

        _response_types_map = {
            "200": "SuccessResponse",
            "202": "SuccessAcceptedResponse",
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "403": "ErrorResponse",
            "404": "ErrorResponse",
            "405": "ErrorResponse",
            "408": "ErrorResponse",
            "409": "ErrorResponse",
            "410": "ErrorResponse",
            "429": "ErrorResponse",
            "500": "ErrorResponse",
            "503": "ErrorResponse",
            "504": "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            "/api/v2/roles/{name}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
            _deserialize_response_fn=self.deserialize,
        )
