"""
Snowflake Stage API.

The Snowflake Stage API is a REST API that you can use to access, update, and perform certain actions on stage resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from typing import TYPE_CHECKING, Iterable, Iterator, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.stage._generated.models.file_transfer_material import FileTransferMaterial
from snowflake.core.stage._generated.models.presigned_url_request import PresignedUrlRequest
from snowflake.core.stage._generated.models.stage import Stage
from snowflake.core.stage._generated.models.stage_file import StageFile

from .stage_api import StageApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class StageCollectionBase(SchemaObjectCollectionParent["StageResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = StageApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(self, stage: Stage, mode: Optional[Union[CreateMode, str]] = None) -> "StageResource":  # noqa: F821
        """Create a stage.

        Parameters
        __________
        stage: Stage
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_stage(
            self.database.name,
            self.schema.name,
            stage=stage,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(stage), self)
        return self._ref_class(stage.name, self)

    @api_telemetry
    def create_async(
        self, stage: Stage, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["StageResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_stage(
            self.database.name,
            self.schema.name,
            stage=stage,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(future, lambda _: self._ref_class(get_function_name_with_args(stage), self))
        return PollingOperation(
            future, lambda _: self._ref_class(stage if isinstance(stage, str) else stage.name, self)
        )

    @api_telemetry
    def iter(self, *, like: Optional[str] = None) -> Iterator[Stage]:
        """List stages.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        """
        resources = self._api.list_stages(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(self, *, like: Optional[str] = None) -> PollingOperation[Iterator[Stage]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self._api.list_stages(
            self.database.name,
            self.schema.name,
            like=like,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class StageResourceBase(SchemaObjectReferenceMixin["StageCollection"]):
    _collection_class: StageCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: StageCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def fetch(
        self,
    ) -> Stage:
        """Fetch a stage.

        Parameters
        __________
        """
        result = self.collection._api.fetch_stage(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )
        return result

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[Stage]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_stage(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def get_presigned_url(
        self,
        file_path: str,
        presigned_url_request: Optional[PresignedUrlRequest] = None,
    ) -> FileTransferMaterial:
        """Generate a presigned url and optionally encryption materials.

        Parameters
        __________
        file_path: str
             The full stage path of the file. (required)
        presigned_url_request: PresignedUrlRequest
        """
        result = self.collection._api.get_presigned_url(
            self.database.name,
            self.schema.name,
            self._identifier,
            file_path=file_path,
            presigned_url_request=presigned_url_request,
            async_req=False,
        )
        return result

    @api_telemetry
    def get_presigned_url_async(
        self,
        file_path: str,
        presigned_url_request: Optional[PresignedUrlRequest] = None,
    ) -> PollingOperation[FileTransferMaterial]:
        """An asynchronous version of :func:`get_presigned_url`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.get_presigned_url(
            self.database.name,
            self.schema.name,
            self._identifier,
            file_path=file_path,
            presigned_url_request=presigned_url_request,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def list_files(
        self,
        pattern: Optional[str] = None,
    ) -> Iterable[StageFile]:
        """List files in the stage.

        Parameters
        __________
        pattern: str
             Parameter that filters the command output by a regular expression pattern.
        """
        result = self.collection._api.list_files(
            self.database.name,
            self.schema.name,
            self._identifier,
            pattern=pattern,
            async_req=False,
        )
        return result

    @api_telemetry
    def list_files_async(
        self,
        pattern: Optional[str] = None,
    ) -> PollingOperation[Iterable[StageFile]]:
        """An asynchronous version of :func:`list_files`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.list_files(
            self.database.name,
            self.schema.name,
            self._identifier,
            pattern=pattern,
            async_req=True,
        )

        return PollingOperations.iterator(future)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a stage.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_stage(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_stage(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
