"""
Snowflake Stream API.

The Snowflake Stream API is a REST API that you can use to access, update, and perform certain actions on Stream resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any, ClassVar, Dict, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated

import snowflake.core.stream._generated.models

from snowflake.core.stream._generated.models import *  # noqa: F403


class StreamSource(BaseModel):
    """A model object representing the StreamSource resource.

    Constructs an object of type StreamSource with the provided properties.

    Parameters
    __________
    name : str
        Name of the source whose changes are tracked by the stream
    database_name : str, optional
        Database name to which stream source type belongs. If not provided, database  name provided in the path param will be used.
    schema_name : str, optional
        Schema name to which stream source type belongs. If not provided, schema name provided in the path param will be used.
    """

    name: Annotated[str, Field(strict=True)]

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = ["src_type", "name", "database_name", "schema_name"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "src_type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "external_table": "StreamSourceExternalTable",
        "stage": "StreamSourceStage",
        "table": "StreamSourceTable",
        "view": "StreamSourceView",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        "StreamSourceExternalTable": "external_table",
        "StreamSourceStage": "stage",
        "StreamSourceTable": "table",
        "StreamSourceView": "view",
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[StreamSourceExternalTable, StreamSourceStage, StreamSourceTable, StreamSourceView]:
        """Create an instance of StreamSource from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[StreamSourceExternalTable, StreamSourceStage, StreamSourceTable, StreamSourceView]:
        """Create an instance of StreamSource from a dict."""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(snowflake.core.stream._generated.models, object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "StreamSource failed to lookup discriminator value from "
                + json.dumps(obj)
                + ". Discriminator property name: "
                + cls.__discriminator_property_name
                + ", mapping: "
                + json.dumps(cls.__discriminator_value_class_map)
            )


class StreamSourceModel:
    def __init__(
        self,
        name: str,
        # optional properties
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
    ):
        """A model object representing the StreamSource resource.

        Constructs an object of type StreamSource with the provided properties.

        Parameters
        __________
        name : str
            Name of the source whose changes are tracked by the stream
        database_name : str, optional
            Database name to which stream source type belongs. If not provided, database  name provided in the path param will be used.
        schema_name : str, optional
            Schema name to which stream source type belongs. If not provided, schema name provided in the path param will be used.
        """
        self.name = name
        self.database_name = database_name
        self.schema_name = schema_name

    __properties = ["src_type", "name", "database_name", "schema_name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamSource(
            name=self.name,
            database_name=self.database_name,
            schema_name=self.schema_name,
        )

    @classmethod
    def _from_model(cls, model) -> StreamSourceModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Create a dictionary of the properties from a StreamSource.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamSource object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[StreamSourceExternalTableModel, StreamSourceStageModel, StreamSourceTableModel, StreamSourceViewModel]:
        """Create an instance of StreamSource from a dict.

        This method constructs a StreamSource object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamSource
            A StreamSource object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamSource.from_dict(obj))


StreamSource._model_class = StreamSourceModel
