"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.streamlit._generated.models.add_version_streamlit_request_version import (
    AddVersionStreamlitRequestVersion,
    AddVersionStreamlitRequestVersionModel,
)


class AddVersionStreamlitRequest(BaseModel):
    """A model object representing the AddVersionStreamlitRequest resource.

    Constructs an object of type AddVersionStreamlitRequest with the provided properties.

    Parameters
    __________
    source_location : str
        URI to the source location.
    version : AddVersionStreamlitRequestVersion, optional
    """

    source_location: StrictStr

    version: Optional[AddVersionStreamlitRequestVersion] = None

    __properties = ["source_location", "version"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddVersionStreamlitRequest:
        """Create an instance of AddVersionStreamlitRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict["version"] = self.version.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AddVersionStreamlitRequest:
        """Create an instance of AddVersionStreamlitRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddVersionStreamlitRequest.model_validate(obj)

        _obj = AddVersionStreamlitRequest.model_validate(
            {
                "source_location": obj.get("source_location"),
                "version": AddVersionStreamlitRequestVersion.from_dict(obj.get("version"))
                if obj.get("version") is not None
                else None,
            }
        )

        return _obj


class AddVersionStreamlitRequestModel:
    def __init__(
        self,
        source_location: str,
        # optional properties
        version: Optional[AddVersionStreamlitRequestVersion] = None,
    ):
        """A model object representing the AddVersionStreamlitRequest resource.

        Constructs an object of type AddVersionStreamlitRequest with the provided properties.

        Parameters
        __________
        source_location : str
            URI to the source location.
        version : AddVersionStreamlitRequestVersion, optional
        """
        self.source_location = source_location
        self.version = version

    __properties = ["source_location", "version"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AddVersionStreamlitRequest(
            source_location=self.source_location,
            version=self.version._to_model() if self.version is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> AddVersionStreamlitRequestModel:
        return AddVersionStreamlitRequestModel(
            source_location=model.source_location,
            version=AddVersionStreamlitRequestVersionModel._from_model(model.version) if model.version else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AddVersionStreamlitRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AddVersionStreamlitRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AddVersionStreamlitRequestModel:
        """Create an instance of AddVersionStreamlitRequest from a dict.

        This method constructs a AddVersionStreamlitRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AddVersionStreamlitRequest
            A AddVersionStreamlitRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AddVersionStreamlitRequest.from_dict(obj))


AddVersionStreamlitRequest._model_class = AddVersionStreamlitRequestModel
