# (C) Copyright 2020-2025 Enthought, Inc., Austin, TX
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in LICENSE.txt and may be redistributed only under
# the conditions described in the aforementioned license. The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
#
# Thanks for using Enthought open source!

from enum import IntEnum
from typing import Any


class TraitKind(IntEnum):
    trait = ...
    python = ...
    event = ...
    delegate = ...
    property = ...
    disallow = ...
    read_only = ...
    constant = ...
    generic = ...


class ValidateTrait(IntEnum):
    type = ...
    instance = ...
    self_type = ...
    int_range = ...
    float_range = ...
    enum = ...
    map = ...
    complex = ...
    slow = ...
    tuple = ...
    prefix_map = ...
    coerce = ...
    cast = ...
    function = ...
    python = ...
    adapt = ...
    int = ...
    float = ...
    callable = ...

class ComparisonMode(IntEnum):
    none = ...
    identity = ...
    equality = ...

NO_COMPARE: Any
OBJECT_IDENTITY_COMPARE: Any
RICH_COMPARE: Any

class DefaultValue(IntEnum):
    unspecified = ...
    constant = ...
    missing = ...
    object = ...
    list_copy = ...
    dict_copy = ...
    trait_list_object = ...
    trait_dict_object = ...
    callable_and_args = ...
    callable = ...
    trait_set_object = ...
    disallow = ...


MAXIMUM_DEFAULT_VALUE_TYPE: Any
default_value_map: Any
