from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkIOMovie
import vtkmodules.vtkIOVideo

class vtkFFMPEGVideoSource(vtkmodules.vtkIOVideo.vtkVideoSource):
    decoding_threads:'getset_descriptor'
    end_of_file:'getset_descriptor'
    file_name:'getset_descriptor'
    frame_rate:'getset_descriptor'
    frame_size:'getset_descriptor'
    output_format:'getset_descriptor'
    stereo3d:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDecodingThreads(self) -> int: ...
    def GetEndOfFile(self) -> bool: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStereo3D(self) -> bool: ...
    def Grab(self) -> None: ...
    def Initialize(self) -> None: ...
    def InternalGrab(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFFMPEGVideoSource': ...
    def Play(self) -> None: ...
    def Record(self) -> None: ...
    def ReleaseSystemResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFFMPEGVideoSource': ...
    def SetDecodingThreads(self, _arg:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetFrameRate(self, rate:float) -> None: ...
    @overload
    def SetFrameSize(self, x:int, y:int, z:int) -> None: ...
    @overload
    def SetFrameSize(self, dim:MutableSequence[int]) -> None: ...
    def SetOutputFormat(self, format:int) -> None: ...
    def Stop(self) -> None: ...

class vtkFFMPEGVideoSourceAudioCallbackData(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkFFMPEGVideoSourceAudioCallbackData') -> None: ...

class vtkFFMPEGVideoSourceVideoCallbackData(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkFFMPEGVideoSourceVideoCallbackData') -> None: ...

class vtkFFMPEGWriter(vtkmodules.vtkIOMovie.vtkGenericMovieWriter):
    bit_rate:'getset_descriptor'
    bit_rate_tolerance:'getset_descriptor'
    compression:'getset_descriptor'
    quality:'getset_descriptor'
    rate:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompressionOff(self) -> None: ...
    def CompressionOn(self) -> None: ...
    def End(self) -> None: ...
    def GetBitRate(self) -> int: ...
    def GetBitRateTolerance(self) -> int: ...
    def GetCompression(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetQuality(self) -> int: ...
    def GetQualityMaxValue(self) -> int: ...
    def GetQualityMinValue(self) -> int: ...
    def GetRate(self) -> int: ...
    def GetRateMaxValue(self) -> int: ...
    def GetRateMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFFMPEGWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFFMPEGWriter': ...
    def SetBitRate(self, _arg:int) -> None: ...
    def SetBitRateTolerance(self, _arg:int) -> None: ...
    def SetCompression(self, _arg:bool) -> None: ...
    def SetQuality(self, _arg:int) -> None: ...
    def SetRate(self, _arg:int) -> None: ...
    def Start(self) -> None: ...
    def Write(self) -> None: ...

